/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBIndexDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDeltaWithProperties;
import org.eclipse.net4j.internal.db.ddl.delta.DBIndexFieldDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBTableDelta;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBIndexDelta
extends DBDeltaWithProperties
implements IDBIndexDelta {
    private static final long serialVersionUID = 1L;
    private Map<String, IDBIndexFieldDelta> indexFieldDeltas = new HashMap<String, IDBIndexFieldDelta>();

    public DBIndexDelta(DBDelta parent, String name, IDBDelta.ChangeKind changeKind) {
        super(parent, name, changeKind);
    }

    public DBIndexDelta(DBDelta parent, IDBIndex index, IDBIndex oldIndex) {
        this(parent, DBIndexDelta.getName(index, oldIndex), DBIndexDelta.getChangeKind(index, oldIndex));
        Boolean oldOptional;
        IDBIndex.Type oldType;
        IDBIndex.Type type = index == null ? null : index.getType();
        IDBIndex.Type type2 = oldType = oldIndex == null ? null : oldIndex.getType();
        if (!ObjectUtil.equals((Object)((Object)type), (Object)((Object)oldType))) {
            this.addPropertyDelta(new DBPropertyDelta<IDBIndex.Type>(this, "type", IDBPropertyDelta.Type.STRING, type, oldType));
        }
        Boolean optional = index == null ? null : Boolean.valueOf(((InternalDBIndex)index).isOptional());
        Boolean bl = oldOptional = oldIndex == null ? null : Boolean.valueOf(((InternalDBIndex)oldIndex).isOptional());
        if (!ObjectUtil.equals((Object)optional, (Object)oldOptional)) {
            this.addPropertyDelta(new DBPropertyDelta<Boolean>(this, "optional", IDBPropertyDelta.Type.BOOLEAN, optional, oldOptional));
        }
        IDBSchemaElement[] indexFields = index == null ? InternalDBIndex.NO_INDEX_FIELDS : index.getIndexFields();
        IDBSchemaElement[] oldIndexFields = oldIndex == null ? InternalDBIndex.NO_INDEX_FIELDS : oldIndex.getIndexFields();
        DBIndexDelta.compare((IDBSchemaElement[])indexFields, (IDBSchemaElement[])oldIndexFields, (DBDelta.SchemaElementComparator)new DBDelta.SchemaElementComparator<IDBIndexField>(){

            @Override
            public void compare(IDBIndexField indexField, IDBIndexField oldIndexField) {
                DBIndexFieldDelta indexFieldDelta = new DBIndexFieldDelta(DBIndexDelta.this, indexField, oldIndexField);
                if (!indexFieldDelta.isEmpty()) {
                    DBIndexDelta.this.addIndexFieldDelta(indexFieldDelta);
                }
            }
        });
    }

    protected DBIndexDelta() {
    }

    @Override
    public IDBDelta.DeltaType getDeltaType() {
        return IDBDelta.DeltaType.INDEX;
    }

    @Override
    public DBTableDelta getParent() {
        return (DBTableDelta)super.getParent();
    }

    @Override
    public int getIndexFieldDeltaCount() {
        return this.indexFieldDeltas.size();
    }

    @Override
    public DBIndexFieldDelta getIndexFieldDelta(int position) {
        for (IDBIndexFieldDelta indexFieldDelta : this.indexFieldDeltas.values()) {
            if (indexFieldDelta.getPosition() != position) continue;
            return (DBIndexFieldDelta)indexFieldDelta;
        }
        return null;
    }

    @Override
    public DBIndexFieldDelta getIndexFieldDelta(String name) {
        return (DBIndexFieldDelta)this.indexFieldDeltas.get(name);
    }

    @Override
    public Map<String, IDBIndexFieldDelta> getIndexFieldDeltas() {
        return Collections.unmodifiableMap(this.indexFieldDeltas);
    }

    public DBIndexFieldDelta[] getIndexFieldDeltasSortedByPosition() {
        Object[] result = this.indexFieldDeltas.values().toArray(new DBIndexFieldDelta[this.indexFieldDeltas.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public IDBIndex getSchemaElement(IDBSchema schema) {
        IDBTable table = this.getParent().getSchemaElement(schema);
        if (table == null) {
            return null;
        }
        return table.getIndex(this.getName());
    }

    @Override
    public String toString() {
        return MessageFormat.format("DBIndexDelta[name={0}, kind={1}, propertyDeltas={2}, indexFieldDeltas={3}]", new Object[]{this.getName(), this.getChangeKind(), this.getPropertyDeltas().values(), this.indexFieldDeltas.values()});
    }

    public void addIndexFieldDelta(DBIndexFieldDelta indexFieldDelta) {
        this.indexFieldDeltas.put(indexFieldDelta.getName(), indexFieldDelta);
        this.resetElements();
    }

    @Override
    protected void doAccept(IDBDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void collectElements(List<IDBDelta> elements) {
        elements.addAll(this.indexFieldDeltas.values());
        super.collectElements(elements);
    }
}

