/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.objectteams.otdt.internal.ui.javaeditor.OTJavaEditorMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class RoleOverrideIndicatorManager
implements IJavaReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.objectteams.otdt.ui.roleOverrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;
    private ITypeRoot fJavaElement;

    public RoleOverrideIndicatorManager(IAnnotationModel annotationModel, ITypeRoot javaElement, CompilationUnit ast) {
        Assert.isNotNull((Object)annotationModel);
        Assert.isNotNull((Object)javaElement);
        this.fJavaElement = javaElement;
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        this.updateAnnotations(ast, (IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(CompilationUnit ast, IProgressMonitor progressMonitor) {
        if (ast == null || progressMonitor.isCanceled()) {
            return;
        }
        final HashMap annotationMap = new HashMap(10);
        ast.accept(new ASTVisitor(false){

            public boolean visit(RoleTypeDeclaration node) {
                ITypeBinding[] definingRoles;
                ITypeBinding binding = node.resolveBinding();
                if (binding != null && (definingRoles = binding.getSuperRoles()) != null && definingRoles.length > 0) {
                    ITypeBinding definingRole = definingRoles[0];
                    ITypeBinding definingType = definingRole.getDeclaringClass();
                    String qualifiedRoleName = String.valueOf(definingType.getQualifiedName()) + "." + binding.getName();
                    String text = NLS.bind((String)OTJavaEditorMessages.RoleOverrideIndicator_overrides, (Object[])new Object[]{BasicElementLabels.getJavaElementName((String)qualifiedRoleName)});
                    SimpleName name = node.getName();
                    Position position = new Position(name.getStartPosition(), name.getLength());
                    annotationMap.put(new OverrideIndicator(text, binding.getKey()), position);
                }
                return true;
            }
        });
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(CompilationUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        this.updateAnnotations(ast, progressMonitor);
    }

    public class OverrideIndicator
    extends Annotation {
        private String fAstNodeKey;

        OverrideIndicator(String text, String key) {
            super(RoleOverrideIndicatorManager.ANNOTATION_TYPE, false, text);
            this.fAstNodeKey = key;
        }

        public void open() {
            ASTNode node;
            CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)RoleOverrideIndicatorManager.this.fJavaElement, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            if (ast != null && (node = ast.findDeclaringNode(this.fAstNodeKey)) instanceof TypeDeclaration) {
                try {
                    IJavaElement definingRole;
                    ITypeBinding typeBinding = ((TypeDeclaration)node).resolveBinding();
                    ITypeBinding[] tsuperRoles = typeBinding.getSuperRoles();
                    if (tsuperRoles != null && tsuperRoles.length > 0 && (definingRole = tsuperRoles[0].getJavaElement()) != null) {
                        JavaUI.openInEditor((IJavaElement)definingRole, (boolean)true, (boolean)true);
                        return;
                    }
                }
                catch (CoreException e) {
                    ExceptionHandler.handle((CoreException)e, (String)OTJavaEditorMessages.RoleOverrideIndicator_open_error_title, (String)OTJavaEditorMessages.RoleOverrideIndicator_open_error_messageHasLogEntry);
                    return;
                }
            }
            String title = OTJavaEditorMessages.RoleOverrideIndicator_open_error_title;
            String message = OTJavaEditorMessages.RoleOverrideIndicator_open_error_message;
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
        }
    }
}

