/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.menu.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.DefaultNavigationMenu;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.HyperlinkButton;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.MoreButton;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.NavigationSubMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.widgets.editors.SelectionMenu;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionMenuSelectionChangedListener
implements ISelectionChangedListener {
    protected DefaultNavigationMenu navigationMenu;
    protected List<Object> selectionMenuItems;
    protected SelectionMenu selectionMenu;
    protected List<SelectionMenu> subMenus;
    protected Object umlElement;
    protected boolean moreButton = false;

    public SelectionMenuSelectionChangedListener(DefaultNavigationMenu navigationMenu, SelectionMenu selectionMenu, List<Object> selectionMenuItems, Object umlElement, List<SelectionMenu> subMenus) {
        this.navigationMenu = navigationMenu;
        this.selectionMenu = selectionMenu;
        this.selectionMenuItems = selectionMenuItems;
        this.umlElement = umlElement;
        this.subMenus = subMenus;
    }

    public SelectionMenuSelectionChangedListener(DefaultNavigationMenu navigationMenu, SelectionMenu selectionMenu, List<Object> selectionMenuItems) {
        this.navigationMenu = navigationMenu;
        this.selectionMenu = selectionMenu;
        this.selectionMenuItems = selectionMenuItems;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (!(selectedElement instanceof NavigationSubMenuButton) && this.subMenus != null && event.getSource() instanceof TableViewer) {
            Shell levelShell = ((TableViewer)event.getSource()).getTable().getShell();
            ArrayList<SelectionMenu> subMenusToDelete = new ArrayList<SelectionMenu>();
            for (SelectionMenu subMenu : this.subMenus) {
                if (!subMenu.getParentShell().equals(levelShell)) continue;
                subMenusToDelete.add(subMenu);
                subMenu.dispose();
            }
            this.subMenus.removeAll(subMenusToDelete);
        }
        if (selectedElement instanceof NavigableElement) {
            List<Object> viewsToSelect = this.navigationMenu.getViewsToSelect((NavigableElement)selectedElement, false);
            if (viewsToSelect != null && !viewsToSelect.isEmpty()) {
                if (this.navigationMenu.getSelectedView() != null) {
                    viewsToSelect.removeAll(Collections.singleton(this.navigationMenu.getSelectedView()));
                }
                if (!viewsToSelect.isEmpty()) {
                    this.navigationMenu.revealObject(viewsToSelect.get(0));
                    return;
                }
            }
            this.navigationMenu.showInModelExplorer((NavigableElement)selectedElement);
        } else if (selectedElement instanceof HyperlinkButton) {
            ((HyperlinkButton)selectedElement).getAction().run();
            this.navigationMenu.exitItem();
        } else if (selectedElement instanceof MoreButton) {
            ((LinkedList)this.selectionMenuItems).removeLast();
            this.navigationMenu.addContextualMenus(this.selectionMenuItems, this.umlElement);
            this.selectionMenu.refresh();
        } else {
            this.navigationMenu.revealObject(selectedElement);
        }
    }
}

