/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;

public class AxisConfigurationUtils {
    private AxisConfigurationUtils() {
    }

    public static IAxisConfiguration getIAxisConfigurationUsedInTable(Table table, EClass eClass, boolean onColumn) {
        AbstractHeaderAxisConfiguration localConf;
        IAxisConfiguration iAxisConfiguration = null;
        ArrayList<AbstractHeaderAxisConfiguration> headerConfigurations = new ArrayList<AbstractHeaderAxisConfiguration>();
        if (onColumn) {
            localConf = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTable(table);
            if (localConf != null) {
                headerConfigurations.add(localConf);
            }
            if ((localConf = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table)) != null) {
                headerConfigurations.add(localConf);
            }
        } else {
            localConf = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
            if (localConf != null) {
                headerConfigurations.add(localConf);
            }
            if ((localConf = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table)) != null) {
                headerConfigurations.add(localConf);
            }
        }
        Iterator iter = headerConfigurations.iterator();
        while (iter.hasNext() && iAxisConfiguration == null) {
            Iterator confIter = ((AbstractHeaderAxisConfiguration)iter.next()).getOwnedAxisConfigurations().iterator();
            while (confIter.hasNext() && iAxisConfiguration == null) {
                IAxisConfiguration current = (IAxisConfiguration)confIter.next();
                if (current.eClass() != eClass) continue;
                iAxisConfiguration = current;
            }
        }
        return iAxisConfiguration;
    }
}

