/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel.proxy;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Member;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;

public class AttributeProxyImpl<X, T>
implements Attribute<X, T>,
Serializable {
    protected Attribute<X, T> attribute = null;
    protected transient Set<WeakReference<EntityManagerFactoryImpl>> factories = new HashSet<WeakReference<EntityManagerFactoryImpl>>();

    public synchronized Attribute<X, T> getAttribute() {
        if (this.attribute == null) {
            for (WeakReference<EntityManagerFactoryImpl> factoryRef : this.factories) {
                EntityManagerFactoryImpl factory = (EntityManagerFactoryImpl)factoryRef.get();
                if (factory != null) {
                    factory.getDatabaseSession();
                    continue;
                }
                this.factories.remove(factoryRef);
            }
        }
        return this.attribute;
    }

    public synchronized Attribute<X, T> getAttributeInternal() {
        return this.attribute;
    }

    public synchronized void setAttribute(Attribute<X, T> attribute) {
        this.attribute = attribute;
    }

    public synchronized void addFactory(EntityManagerFactoryImpl factory) {
        for (WeakReference<EntityManagerFactoryImpl> factoryRef : this.factories) {
            EntityManagerFactoryImpl fImpl = (EntityManagerFactoryImpl)factoryRef.get();
            if (fImpl == null || !fImpl.equals(factory)) continue;
            return;
        }
        this.factories.add(new WeakReference<EntityManagerFactoryImpl>(factory));
    }

    public String getName() {
        return this.getAttribute().getName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.getAttribute().getPersistentAttributeType();
    }

    public ManagedType<X> getDeclaringType() {
        return this.getAttribute().getDeclaringType();
    }

    public Class<T> getJavaType() {
        return this.getAttribute().getJavaType();
    }

    public Member getJavaMember() {
        return this.getAttribute().getJavaMember();
    }

    public boolean isAssociation() {
        return this.getAttribute().isAssociation();
    }

    public boolean isCollection() {
        return this.getAttribute().isCollection();
    }
}

