/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenRunner;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class RebuildArtifactsOperation
implements IOperation {
    private IJavaProject m_javaProject;

    @Override
    public String getOperationName() {
        return "Rebuild all Web Service Artifacts of Project " + this.getJavaProject().getElementName();
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getJavaProject()), (String)"Java Project must exist.", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)100);
        IProject project = this.getJavaProject().getProject();
        project.refreshLocal(2, (IProgressMonitor)progress.newChild(2));
        if (progress.isCanceled()) {
            return;
        }
        this.deleteOutputFolderContents(project, progress.newChild(4));
        if (progress.isCanceled()) {
            return;
        }
        progress.worked(44);
        try {
            MavenRunner.execute((MavenBuild)new MavenBuild().withGoal("clean").withGoal("process-resources").withWorkingDirectory(project.getLocation().toFile()));
        }
        catch (Exception e) {
            SdkLog.error((String)"Unable to rebuild artifacts. See maven console for details.", (Object[])new Object[]{e});
        }
        progress.worked(48);
        progress.setTaskName("Refresh project");
        project.refreshLocal(2, (IProgressMonitor)progress.newChild(2));
    }

    protected void deleteOutputFolderContents(IProject project, SubMonitor progress) throws CoreException {
        final HashSet resourcesToDelete = new HashSet();
        final IFolder outFolder = project.getFolder("target");
        if (!outFolder.exists()) {
            return;
        }
        outFolder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                boolean isOutFolder = Objects.equals(outFolder, resource);
                if (!isOutFolder) {
                    resourcesToDelete.add(resource);
                }
                return isOutFolder;
            }
        });
        progress.beginTask("Delete existing Artifacts", resourcesToDelete.size());
        for (IResource r : resourcesToDelete) {
            try {
                r.delete(1, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                SdkLog.warning((String)"Unable to delete resource '{}'.", (Object[])new Object[]{r.getFullPath().toOSString(), e});
            }
        }
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.m_javaProject = javaProject;
    }
}

