/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.swt.graphics.Image;

public class StyleConfigurationQuery {
    protected StyleConfiguration styleConfig;

    public StyleConfigurationQuery(StyleConfiguration styleConfiguration) {
        this.styleConfig = styleConfiguration;
    }

    public Image getLabelIcon(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        if (!this.labelIconsMustBeHidden(vpElement)) {
            return this.styleConfig.getLabelIcon(vpElement, editPart);
        }
        return null;
    }

    protected boolean labelIconsMustBeHidden(DDiagramElement element) {
        boolean mustHideLabelIconsOnShape = false;
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        if (element instanceof DEdge) {
            mustHideLabelIconsOnShape = prefs.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_HIDE_LABEL_ICONS_ON_CONNECTORS.name());
        } else if (element instanceof AbstractDNode) {
            mustHideLabelIconsOnShape = prefs.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_HIDE_LABEL_ICONS_ON_SHAPES.name());
        }
        return mustHideLabelIconsOnShape;
    }
}

