/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SetDefaultConcernCommand;

public class ResetToDefaultFiltersAction
extends Action {
    public static final String ID = ResetToDefaultFiltersAction.class.getName();
    private TransactionalEditingDomain domain;
    private DDiagram dDiagram;

    public ResetToDefaultFiltersAction(TransactionalEditingDomain domain, DDiagram dDiagram) {
        super(Messages.ResetToDefaultFiltersAction_text, 1);
        this.setId(ID);
        this.setToolTipText(Messages.ResetToDefaultFiltersAction_tooltip);
        ImageDescriptor enabledImage = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/undo_edit.gif");
        ImageDescriptor disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
        this.setImageDescriptor(enabledImage);
        this.setDisabledImageDescriptor(disabledImage);
        this.domain = domain;
        this.dDiagram = dDiagram;
    }

    public boolean isEnabled() {
        ConcernDescription defaultConcern;
        boolean isEnabled = true;
        DiagramDescription description = this.dDiagram.getDescription();
        if (description != null && (defaultConcern = description.getDefaultConcern()) != null) {
            isEnabled = !EcoreUtil.equals((List)defaultConcern.getFilters(), (List)this.dDiagram.getActivatedFilters());
        }
        return isEnabled;
    }

    public void run() {
        this.domain.getCommandStack().execute((Command)new SetDefaultConcernCommand(this.domain, this.dDiagram));
    }
}

