/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.EditorPart;

public class ShowInSystemManagementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        Object element = null;
        if (part instanceof EditorPart) {
            IEditorInput input = ((EditorPart)part).getEditorInput();
            Object object = element = input != null ? input.getAdapter(Object.class) : null;
        }
        if (element != null) {
            ShowInSystemManagementHandler.setAndCheckSelection("org.eclipse.tcf.te.ui.views.View", element);
        }
        return null;
    }

    public static void setAndCheckSelection(final String id, final Object element) {
        Assert.isNotNull((Object)id);
        final AtomicReference viewPart = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    try {
                        viewPart.set(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id));
                    }
                    catch (Exception exception) {}
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        }
        runnable = new Runnable(){

            @Override
            public void run() {
                IViewPart part = (IViewPart)viewPart.get();
                ((CommonNavigator)part).getCommonViewer().setSelection((ISelection)new StructuredSelection(element), true);
                IStructuredSelection newSel = (IStructuredSelection)((CommonNavigator)part).getCommonViewer().getSelection();
                if (newSel == null || newSel.isEmpty() || !newSel.getFirstElement().equals(element)) {
                    ICategory[] iCategoryArray = CategoriesExtensionPointManager.getInstance().getCategories(false);
                    int n = iCategoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICategory category = iCategoryArray[n2];
                        if (category.belongsTo(element)) {
                            if (part instanceof CommonNavigator) {
                                ((CommonNavigator)part).getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)category), true);
                                ((CommonNavigator)part).getCommonViewer().expandToLevel((Object)category, 1);
                            }
                            ((CommonNavigator)part).getCommonViewer().setSelection((ISelection)new StructuredSelection(element), true);
                            newSel = (IStructuredSelection)((CommonNavigator)part).getCommonViewer().getSelection();
                            if (newSel != null && !newSel.isEmpty() && newSel.getFirstElement().equals(element)) {
                                return;
                            }
                        }
                        ++n2;
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }
}

