/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.util.SymbolHelper;
import org.eclipse.tracecompass.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.swtchart.LineStyle;

public class XYChartLegendImageProvider
implements ILegendImageProvider {
    private final TmfCommonXAxisChartViewer fChartViewer;

    public XYChartLegendImageProvider(TmfCommonXAxisChartViewer chartViewer) {
        this.fChartViewer = chartViewer;
    }

    @Override
    public Image getLegendImage(int imageHeight, int imageWidth, @NonNull String name) {
        IYAppearance appearance = this.fChartViewer.getSeriesAppearance(name);
        RGBAColor rgb = appearance.getColor();
        Color lineColor = new Color((Device)Display.getDefault(), (int)rgb.getRed(), (int)rgb.getGreen(), (int)rgb.getBlue());
        Color background = Display.getDefault().getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{background.getRGB(), lineColor.getRGB()});
        ImageData imageData = new ImageData(imageWidth, imageHeight, 8, palette);
        imageData.transparentPixel = 0;
        Image image = new Image((Device)Display.getDefault(), imageData);
        GC gc = new GC((Drawable)image);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, imageWidth, imageHeight);
        XYChartLegendImageProvider.drawStyleLine(gc, lineColor, imageWidth, imageHeight, appearance);
        XYChartLegendImageProvider.drawStyledDot(gc, lineColor, imageWidth, imageHeight, appearance);
        gc.dispose();
        lineColor.dispose();
        return image;
    }

    private static void drawStyleLine(GC gc, Color lineColor, int imageWidth, int imageHeight, IYAppearance appearance) {
        Color prev = gc.getForeground();
        LineStyle lineStyle = LineStyle.valueOf((String)appearance.getStyle());
        if (lineStyle != LineStyle.NONE) {
            gc.setForeground(lineColor);
            gc.setLineWidth(appearance.getWidth());
            gc.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()).ordinal());
            gc.drawLine(0, imageHeight / 2, imageWidth, imageHeight / 2);
            gc.setForeground(prev);
        }
    }

    private static void drawStyledDot(GC gc, Color lineColor, int imageWidth, int imageHeight, IYAppearance appearance) {
        String symbolStyle = appearance.getSymbolStyle();
        int symbolSize = appearance.getSymbolSize();
        int centerX = imageWidth / 2;
        int centerY = imageHeight / 2;
        Color prevBg = gc.getBackground();
        Color prevFg = gc.getForeground();
        switch (symbolStyle) {
            case "CIRCLE": {
                SymbolHelper.drawCircle(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "DIAMOND": {
                SymbolHelper.drawDiamond(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "SQUARE": {
                SymbolHelper.drawSquare(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "CROSS": {
                SymbolHelper.drawCross(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "PLUS": {
                SymbolHelper.drawPlus(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "INVERTED_TRIANGLE": {
                SymbolHelper.drawInvertedTriangle(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
            case "TRIANGLE": {
                SymbolHelper.drawTriangle(gc, lineColor, symbolSize, centerX, centerY);
                break;
            }
        }
        gc.setForeground(prevFg);
        gc.setBackground(prevBg);
    }
}

