/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.intro.universal.IUniversalIntroConstants;
import org.eclipse.ui.internal.intro.universal.UniversalIntroPlugin;

public class Log
implements IUniversalIntroConstants {
    public static final boolean DEBUG = false;
    public static boolean logWarning = false;
    public static boolean logInfo = false;
    public static boolean logPerformance = false;
    private static final ILog pluginLog = UniversalIntroPlugin.getDefault().getLog();

    static {
        if (UniversalIntroPlugin.getDefault().isDebugging()) {
            logWarning = true;
            logInfo = Log.getDebugOption("/trace/logInfo");
            logPerformance = Log.getDebugOption("/trace/logPerformance");
        }
    }

    private static boolean getDebugOption(String option) {
        return "true".equalsIgnoreCase(Platform.getDebugOption((String)("org.eclipse.ui.intro.universal" + option)));
    }

    public static synchronized void error(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, "org.eclipse.ui.intro.universal", 0, message, ex);
        pluginLog.log((IStatus)errorStatus);
    }

    public static synchronized void info(String message) {
        if (!logInfo) {
            return;
        }
        if (message == null) {
            message = "";
        }
        Status infoStatus = new Status(1, "org.eclipse.ui.intro.universal", 0, message, null);
        pluginLog.log((IStatus)infoStatus);
    }

    public static synchronized void forcedInfo(String message) {
        if (message == null) {
            message = "";
        }
        Status infoStatus = new Status(1, "org.eclipse.ui.intro.universal", 0, message, null);
        pluginLog.log((IStatus)infoStatus);
    }

    public static synchronized void warning(String message) {
        if (!logWarning) {
            return;
        }
        if (message == null) {
            message = "";
        }
        Status warningStatus = new Status(2, "org.eclipse.ui.intro.universal", 0, message, null);
        pluginLog.log((IStatus)warningStatus);
    }

    public static synchronized void debugMessage(String className, String message) {
    }
}

