/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.collect.Iterators;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 * @since 1.4
 */
@SuppressWarnings("all")
public class RemoveQueryHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    ISelection _currentSelection = HandlerUtil.getCurrentSelection(event);
    final IStructuredSelection selection = ((IStructuredSelection) _currentSelection);
    final Procedure1<QueryResultTreeMatcher> _function = (QueryResultTreeMatcher matcher) -> {
      boolean _isReadOnlyEngine = matcher.getParent().isReadOnlyEngine();
      boolean _not = (!_isReadOnlyEngine);
      if (_not) {
        matcher.remove();
      }
    };
    IteratorExtensions.<QueryResultTreeMatcher>forEach(Iterators.<QueryResultTreeMatcher>filter(selection.iterator(), QueryResultTreeMatcher.class), _function);
    return null;
  }
}
