/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.source;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Refactoring;

public class RhinoSourcePathComputer
implements ISourcePathComputerDelegate {
    static final ISourceContainer[] NO_CONTAINERS = new ISourceContainer[0];

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IFile script;
        HashSet<Object> containers = new HashSet<Object>();
        List includes = configuration.getAttribute("includepath", null);
        if (includes != null) {
            String entry2 = null;
            String name = null;
            for (String entry2 : includes) {
                int kind = Integer.parseInt(entry2.substring(0, 1));
                name = entry2.substring(1);
                switch (kind) {
                    case 1: {
                        File file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(name);
                        if (file == null) break;
                        containers.add(new FolderSourceContainer(file.getParent(), false));
                        break;
                    }
                    case 2: {
                        File file = new File(name);
                        if (!file.exists()) break;
                        containers.add(new DirectorySourceContainer(file.getParentFile(), false));
                    }
                }
            }
        }
        if ((script = Refactoring.getScript(configuration)) != null) {
            containers.add(new FolderSourceContainer(script.getParent(), false));
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }
}

