/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionHistory;

public abstract class StructureSelectionAction
extends Action {
    public static final String NEXT = "SelectNextElement";
    public static final String PREVIOUS = "SelectPreviousElement";
    public static final String ENCLOSING = "SelectEnclosingElement";
    public static final String HISTORY = "RestoreLastSelection";
    private JavaEditor fEditor;
    private SelectionHistory fSelectionHistory;

    protected StructureSelectionAction(String text, JavaEditor editor, SelectionHistory history) {
        super(text);
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)history);
        this.fEditor = editor;
        this.fSelectionHistory = history;
    }

    protected StructureSelectionAction() {
        super("");
    }

    public final void run() {
        IJavaScriptElement inputElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
        if (!(inputElement instanceof ISourceReference) || !inputElement.exists()) {
            return;
        }
        ISourceReference source = (ISourceReference)inputElement;
        try {
            ISourceRange sourceRange = source.getSourceRange();
            if (sourceRange == null || sourceRange.getLength() == 0) {
                MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)SelectionActionMessages.StructureSelect_error_title, (String)SelectionActionMessages.StructureSelect_error_message);
                return;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(StructureSelectionAction.createSourceRange(selection), source);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fSelectionHistory.remember(new SourceRange(selection.getOffset(), selection.getLength()));
        try {
            this.fSelectionHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
        }
        finally {
            this.fSelectionHistory.listenToSelectionChanges();
        }
    }

    public final ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr) {
        try {
            JavaScriptUnit root = StructureSelectionAction.getAST(sr);
            if (root == null) {
                return oldSourceRange;
            }
            Selection selection = Selection.createFromStartLength(oldSourceRange.getOffset(), oldSourceRange.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            root.accept((ASTVisitor)selAnalyzer);
            return this.internalGetNewSelectionRange(oldSourceRange, sr, selAnalyzer);
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return new SourceRange(oldSourceRange.getOffset(), oldSourceRange.getLength());
        }
    }

    abstract ISourceRange internalGetNewSelectionRange(ISourceRange var1, ISourceReference var2, SelectionAnalyzer var3) throws JavaScriptModelException;

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    protected static ISourceRange getLastCoveringNodeRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaScriptModelException {
        if (selAnalyzer.getLastCoveringNode() == null) {
            return oldSourceRange;
        }
        return StructureSelectionAction.getSelectedNodeSourceRange(sr, selAnalyzer.getLastCoveringNode());
    }

    protected static ISourceRange getSelectedNodeSourceRange(ISourceReference sr, ASTNode nodeToSelect) throws JavaScriptModelException {
        int offset = nodeToSelect.getStartPosition();
        int end = Math.min(sr.getSourceRange().getLength(), nodeToSelect.getStartPosition() + nodeToSelect.getLength() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static JavaScriptUnit getAST(ISourceReference sr) {
        return ASTProvider.getASTProvider().getAST((IJavaScriptElement)sr, ASTProvider.WAIT_YES, null);
    }

    static ISourceRange createSourceRange(int offset, int end) {
        int length = end - offset + 1;
        if (length == 0) {
            length = 1;
        }
        return new SourceRange(Math.max(0, offset), length);
    }

    static ASTNode[] getSiblingNodes(ASTNode node) {
        ASTNode parent = node.getParent();
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent.isChildListProperty()) {
            List siblings = (List)parent.getStructuralProperty(locationInParent);
            return siblings.toArray(new ASTNode[siblings.size()]);
        }
        return null;
    }

    static int findIndex(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

