/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.directedit;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.ASDCCombo;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.ASDComboBoxCellEditor;

public abstract class ComboBoxCellEditorManager
extends DirectEditManager {
    protected Label label;
    static /* synthetic */ Class class$0;

    public ComboBoxCellEditorManager(GraphicalEditPart source, Label label) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ComboBoxCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(source, clazz, (CellEditorLocator)new InternalCellEditorLocator(label));
        this.label = label;
    }

    protected void initCellEditor() {
        String initialLabelText = this.label.getText();
        ASDCCombo combo = (ASDCCombo)this.getCellEditor().getControl();
        combo.setFont(this.label.getFont());
        combo.setForeground(this.label.getForegroundColor());
        combo.setBackground(this.label.getBackgroundColor());
        combo.setVisibleItemCount(20);
        combo.setEditable(false);
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void cancelEditor() {
            }

            public void applyEditorValue() {
            }

            public void editorValueChanged(boolean old, boolean newState) {
            }
        };
        this.getCellEditor().addListener(cellEditorListener);
        String[] item = combo.getItems();
        int i = 0;
        while (i < item.length) {
            if (item[i].equals(initialLabelText)) {
                this.getCellEditor().setValue((Object)new Integer(i));
                break;
            }
            ++i;
        }
    }

    protected boolean isDirty() {
        return true;
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        boolean isLabelTextInList = false;
        List list = this.computeComboContent();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String string = (String)i.next();
            if (!string.equals(this.label.getText())) continue;
            isLabelTextInList = true;
            break;
        }
        if (!isLabelTextInList) {
            list.add(this.label.getText());
        }
        List sortedList = this.computeSortedList(list);
        String[] stringArray = new String[sortedList.size()];
        int i2 = 0;
        while (i2 < stringArray.length) {
            stringArray[i2] = (String)sortedList.get(i2);
            ++i2;
        }
        return this.createCellEditor(composite, stringArray);
    }

    protected CellEditor createCellEditor(Composite composite, String[] stringArray) {
        return new ComboBoxCellEditor(composite, stringArray);
    }

    protected List computeSortedList(List list) {
        return list;
    }

    protected abstract List computeComboContent();

    protected abstract void performModify(Object var1);

    public void performEdit(CellEditor cellEditor) {
        ASDComboBoxCellEditor comboCellEditor = (ASDComboBoxCellEditor)cellEditor;
        ASDCCombo combo = (ASDCCombo)this.getCellEditor().getControl();
        int index = combo.getSelectionIndex();
        if (index != -1) {
            Object value = combo.getItem(index);
            if (comboCellEditor.getSelectedValue() != null) {
                value = comboCellEditor.getSelectedValue();
            }
            this.performModify(value);
        } else {
            String typedValue = combo.getText();
            if (combo.indexOf(typedValue) != -1) {
                this.performModify(typedValue);
            } else {
                String closeMatch = this.getCloseMatch(typedValue, combo.getItems());
                if (closeMatch != null) {
                    this.performModify(closeMatch);
                } else {
                    Display.getCurrent().beep();
                }
            }
        }
    }

    protected String getCloseMatch(String value, String[] items) {
        int matchIndex = -1;
        int i = 0;
        while (i < items.length) {
            String b;
            String item = items[i];
            String a = this.getLocalName(value);
            if (a.equalsIgnoreCase(b = this.getLocalName(item))) {
                matchIndex = i;
                break;
            }
            ++i;
        }
        return matchIndex != -1 ? items[matchIndex] : null;
    }

    protected String getLocalName(String string) {
        int index = string.indexOf(":");
        return index != -1 ? string.substring(index + 1) : string;
    }

    public static class InternalCellEditorLocator
    implements CellEditorLocator {
        protected Label label;

        public InternalCellEditorLocator(Label label) {
            this.label = label;
        }

        public void relocate(CellEditor celleditor) {
            ASDCCombo combo = (ASDCCombo)celleditor.getControl();
            Rectangle labelParentBounds = this.label.getParent().getBounds().getCopy();
            this.label.translateToAbsolute((Translatable)labelParentBounds);
            int x = labelParentBounds.x;
            int y = labelParentBounds.y;
            int widthK = labelParentBounds.width;
            int height = labelParentBounds.height;
            combo.setBounds(x, y + 1, widthK, height - 2);
        }
    }
}

