/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddExtensionElementCommand
extends AddExtensionCommand {
    ExtensibleElement input;
    XSDElementDeclaration element;
    Element appInfo;
    Element newElement;

    public AddExtensionElementCommand(String label, ExtensibleElement input, XSDElementDeclaration element) {
        super(label);
        this.input = input;
        this.element = element;
    }

    public void execute() {
        super.execute();
        Element parentElement = this.input.getElement();
        Document doc = parentElement.getOwnerDocument();
        Element newElement = doc.createElementNS(this.extensionsSchemaSpec.getNamespaceURI(), this.element.getName());
        String prefix = this.addNamespaceDeclarationIfRequired(doc.getDocumentElement(), "p", this.extensionsSchemaSpec.getNamespaceURI());
        newElement.setPrefix(prefix);
        parentElement.appendChild(newElement);
    }

    public void undo() {
    }

    public Object getNewObject() {
        return this.newElement;
    }

    private String addNamespaceDeclarationIfRequired(Element rootElement, String prefixHint, String namespace) {
        String prefix = null;
        NamespaceTable namespaceTable = new NamespaceTable(rootElement.getOwnerDocument());
        namespaceTable.addElement(rootElement);
        prefix = namespaceTable.getPrefixForURI(namespace);
        if (prefix == null) {
            String basePrefix;
            prefix = basePrefix = prefixHint;
            String xmlnsColon = "xmlns:";
            String attributeName = String.valueOf(xmlnsColon) + prefix;
            int count = 0;
            while (rootElement.hasAttribute(attributeName)) {
                prefix = String.valueOf(basePrefix) + ++count;
                attributeName = String.valueOf(xmlnsColon) + prefix;
            }
            rootElement.setAttribute(attributeName, namespace);
        }
        return prefix;
    }
}

