/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsl.internal.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class StylesheetLabelProvider
extends LabelProvider {
    private Image image = XSLDebugUIPlugin.getImageDescriptor("icons/xslt_launch.gif").createImage();

    public Image getImage(Object element) {
        return this.image;
    }

    public String getText(Object element) {
        IPath path;
        LaunchTransform lt = (LaunchTransform)element;
        int index = lt.getPipeline().getTransformDefs().indexOf(lt);
        try {
            path = lt.getPath();
        }
        catch (CoreException coreException) {
            return MessageFormat.format(Messages.StylesheetEntryLabelProvider_Invalid_path, "null");
        }
        if (path == null) {
            return MessageFormat.format(Messages.StylesheetEntryLabelProvider_Invalid_path, "null");
        }
        if (!path.isAbsolute() || !path.isValidPath(path.toString())) {
            return MessageFormat.format(Messages.StylesheetEntryLabelProvider_Invalid_path, path.toString());
        }
        String[] segments = path.segments();
        StringBuffer displayPath = new StringBuffer();
        if (segments.length > 0) {
            displayPath.append(segments[segments.length - 1]);
            displayPath.append(" - ");
            String device = path.getDevice();
            if (device != null) {
                displayPath.append(device);
            }
            displayPath.append(File.separator);
            int i = 0;
            while (i < segments.length - 1) {
                displayPath.append(segments[i]).append(File.separator);
                ++i;
            }
        } else {
            displayPath.append(path.toString());
        }
        return String.valueOf(index + 1) + ") " + displayPath.toString();
    }
}

