/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.launching.XSLTRuntime;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;

public class BaseLaunchHelper {
    private final URL source;
    private final File target;
    protected final LaunchPipeline pipeline;
    private int requestPort = -1;
    private int eventPort = -1;
    private int generatePort = -1;
    private final boolean openFileOnCompletion;
    private final boolean formatFileOnCompletion;
    private final IPath workingDir;

    public BaseLaunchHelper(ILaunchConfiguration configuration) throws CoreException {
        this.workingDir = BaseLaunchHelper.hydrateWorkingDir(configuration);
        this.source = BaseLaunchHelper.hydrateSourceFileURL(configuration);
        this.target = BaseLaunchHelper.hydrateOutputFile(configuration);
        this.pipeline = BaseLaunchHelper.hydratePipeline(configuration);
        this.openFileOnCompletion = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
        this.formatFileOnCompletion = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_FORMAT_FILE", false);
    }

    public int getRequestPort() {
        if (this.requestPort == -1) {
            this.requestPort = BaseLaunchHelper.findFreePort();
        }
        return this.requestPort;
    }

    public int getEventPort() {
        if (this.eventPort == -1) {
            this.eventPort = BaseLaunchHelper.findFreePort();
        }
        return this.eventPort;
    }

    public int getGeneratePort() {
        if (this.generatePort == -1) {
            this.generatePort = BaseLaunchHelper.findFreePort();
        }
        return this.generatePort;
    }

    public LaunchPipeline getPipeline() {
        return this.pipeline;
    }

    public URL getSource() {
        return this.source;
    }

    public File getTarget() {
        return this.target;
    }

    public IPath getWorkingDir() {
        return this.workingDir;
    }

    private static LaunchPipeline hydratePipeline(ILaunchConfiguration configuration) throws CoreException {
        LaunchPipeline pipeline = null;
        String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", null);
        if (s != null && s.length() > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
            pipeline = LaunchPipeline.fromXML(inputStream);
        }
        return pipeline;
    }

    public static URL hydrateSourceFileURL(ILaunchConfiguration configuration) throws CoreException {
        IPath sourceFile = BaseLaunchHelper.hydrateSourceFile(configuration);
        return BaseLaunchHelper.pathToURL(sourceFile);
    }

    private static IPath hydrateWorkingDir(ILaunchConfiguration configuration) throws CoreException {
        String expr = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_WORKING_DIR", null);
        return BaseLaunchHelper.getSubstitutedPath(expr);
    }

    private static IPath hydrateSourceFile(ILaunchConfiguration configuration) throws CoreException {
        String sourceFileExpr = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
        return BaseLaunchHelper.getSubstitutedPath(sourceFileExpr);
    }

    protected static URL pathToURL(IPath sourceFile) throws CoreException {
        URL url = null;
        try {
            url = sourceFile.toFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, sourceFile.toString(), (Throwable)e));
        }
        return url;
    }

    public static File hydrateOutputFile(ILaunchConfiguration configuration) throws CoreException {
        IPath outputFile = null;
        String method = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_DEFAULT_OUTPUT_METHOD", "xml");
        boolean useDefaultOutputFile = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
        if (!useDefaultOutputFile) {
            String outputFileName = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILENAME", null);
            String outputFolderExpr = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FOLDER", null);
            outputFile = BaseLaunchHelper.getSubstitutedPath(outputFolderExpr).append(outputFileName);
        } else {
            outputFile = XSLTRuntime.defaultOutputFileForInputFile(configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null), method);
        }
        return outputFile.toFile();
    }

    private static IPath getSubstitutedPath(String path) throws CoreException {
        if (path != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
        return -1;
    }

    public boolean getOpenFileOnCompletion() {
        return this.openFileOnCompletion;
    }

    public boolean getFormatFileOnCompletion() {
        return this.formatFileOnCompletion;
    }
}

