/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.trace.EndSelectionEvent;
import org.apache.xalan.trace.PrintTraceListener;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TracerEvent;

public class XalanPrintTraceListener
extends PrintTraceListener {
    private final PrintWriter writer;

    public XalanPrintTraceListener(PrintWriter pw) {
        super(pw);
        this.writer = pw;
    }

    public void _trace(TracerEvent ev) {
        switch (ev.m_styleNode.getXSLToken()) {
            case 78: {
                if (!this.m_traceElements) break;
                this.writer.print(String.valueOf(ev.m_styleNode.getSystemId()) + " Line #" + ev.m_styleNode.getLineNumber() + ", " + "Column #" + ev.m_styleNode.getColumnNumber() + " -- " + ev.m_styleNode.getNodeName() + ": ");
                ElemTextLiteral etl = (ElemTextLiteral)ev.m_styleNode;
                String chars = new String(etl.getChars(), 0, etl.getChars().length);
                this.writer.println("    " + chars.trim());
                break;
            }
            case 19: {
                if (!this.m_traceTemplates && !this.m_traceElements) break;
                ElemTemplate et = (ElemTemplate)ev.m_styleNode;
                this.writer.print(String.valueOf(et.getSystemId()) + " Line #" + et.getLineNumber() + ", " + "Column #" + et.getColumnNumber() + ": " + et.getNodeName() + " ");
                if (et.getMatch() != null) {
                    this.writer.print("match='" + et.getMatch().getPatternString() + "' ");
                }
                if (et.getName() != null) {
                    this.writer.print("name='" + et.getName() + "' ");
                }
                this.writer.println();
                break;
            }
            default: {
                if (!this.m_traceElements) break;
                this.writer.println(String.valueOf(ev.m_styleNode.getSystemId()) + " Line #" + ev.m_styleNode.getLineNumber() + ", " + "Column #" + ev.m_styleNode.getColumnNumber() + ": " + ev.m_styleNode.getNodeName());
            }
        }
    }

    public void selected(SelectionEvent ev) throws TransformerException {
        this.writer.print("selected: ");
        super.selected(ev);
    }

    public void selectEnd(EndSelectionEvent ev) throws TransformerException {
        this.writer.print("selectEnd: ");
        super.selectEnd(ev);
    }

    public void trace(TracerEvent ev) {
        this.writer.print("trace: ");
        super.trace(ev);
    }

    public void traceEnd(TracerEvent ev) {
        this.writer.print("traceEnd: ");
        this._trace(ev);
    }
}

