/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.javaconverter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtend.core.javaconverter.JavaConverter;
import org.eclipse.xtend.ide.preferences.XtendPreferenceStoreAccess;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.util.ClipboardUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.ui.imports.ImportsUtil;

public class PasteJavaCodeHandler
extends AbstractHandler {
    @Inject
    private Provider<JavaConverter> javaConverterProvider;
    @Inject
    private ImportsUtil importsUtil;
    @Inject
    private XtendPreferenceStoreAccess prefStoreAccess;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor activeXtextEditor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (activeXtextEditor == null || !activeXtextEditor.isEditable()) {
            return null;
        }
        String clipboardText = ClipboardUtil.getTextFromClipboard();
        if (!Strings.isEmpty((String)clipboardText)) {
            ClipboardUtil.JavaImportData javaImports = ClipboardUtil.getJavaImportsContent();
            this.doPasteJavaCode(activeXtextEditor, clipboardText, javaImports);
        }
        return null;
    }

    private void doPasteJavaCode(XtextEditor activeXtextEditor, String javaCode, ClipboardUtil.JavaImportData javaImports) throws ExecutionException {
        ISourceViewer sourceViewer = activeXtextEditor.getInternalSourceViewer();
        IXtextDocument xtextDocument = activeXtextEditor.getDocument();
        IJavaProject project = null;
        IProject iProject = null;
        IEditorInput editorInput = activeXtextEditor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            iProject = ((IFileEditorInput)editorInput).getFile().getProject();
            project = JavaCore.create((IProject)iProject);
        }
        final int selectionOffset = sourceViewer.getSelectedRange().x - 1;
        EObject targetElement = (EObject)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

            public EObject exec(XtextResource state) throws Exception {
                IParseResult parseResult = state.getParseResult();
                if (parseResult == null) {
                    return null;
                }
                ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)selectionOffset);
                return leafNode.getSemanticElement();
            }
        });
        JavaConverter javaConverter = (JavaConverter)this.javaConverterProvider.get();
        String xtendCode = javaConverter.toXtend(javaCode, javaImports != null ? javaImports.getImports() : null, targetElement, (Object)project, this.conditionalExpressionsAllowed(iProject));
        if (!Strings.isEmpty((String)xtendCode)) {
            if (javaImports != null) {
                this.importsUtil.addImports(javaImports.getImports(), javaImports.getStaticImports(), new String[0], xtextDocument);
            }
            Point selection = sourceViewer.getSelectedRange();
            try {
                xtextDocument.replace(selection.x, selection.y, xtendCode);
            }
            catch (BadLocationException e) {
                throw new ExecutionException("Failed to replace content.", (Throwable)e);
            }
        }
    }

    void doFormat(ISourceViewer sourceViewer, String xtendCode, Point selection) {
        int offset = selection.x;
        int length = xtendCode.length();
        if (offset - 1 >= 0) {
            --offset;
            ++length;
        }
        sourceViewer.setSelectedRange(offset, length);
        sourceViewer.getTextOperationTarget().doOperation(15);
        int restoreCaretAtOffset = sourceViewer.getSelectedRange().x + sourceViewer.getSelectedRange().y;
        sourceViewer.setSelectedRange(restoreCaretAtOffset, 0);
    }

    private boolean conditionalExpressionsAllowed(IProject project) {
        IPreferenceStore prefStore = this.prefStoreAccess.getContextPreferenceStore(project);
        return prefStore.getString("org.eclipse.xtend.core.validation.IssueCodes.ternary_if_operator_is_not_allowed").contentEquals("ignore");
    }
}

