/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.ui;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;
import org.eclipse.xtend.typesystem.xsd.ui.XSDToolsPlugin;
import org.eclipse.xtend.typesystem.xsd.util.Msg;

public class XSDBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.xtend.typesystem.xsd.ui.xsdBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        XSDManager man = XSDToolsPlugin.getDefault().getXSDStore().getXSDManager(this.getProject());
        if (man != null) {
            if (kind == 6) {
                this.fullBuild(man, monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(man, monitor);
                } else {
                    this.incrementalBuild(man, delta, monitor);
                }
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        XSDManager man = XSDToolsPlugin.getDefault().getXSDStore().getXSDManager(this.getProject());
        if (man != null) {
            man.clear();
            man.reloadDirty((ProgressMonitor)new ProgressMonitorAdapter(monitor));
        }
    }

    protected void fullBuild(XSDManager man, IProgressMonitor monitor) throws CoreException {
        try {
            XSDToolsPlugin.traceLog(Msg.create((String)"Running full build on project ").txt(this.getProject().getName()).toString());
            man.clear();
            this.getProject().accept((IResourceVisitor)new XSDResourceVisitor(man));
            man.reloadDirty((ProgressMonitor)new ProgressMonitorAdapter(monitor));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getURI(IResource res) {
        return URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true);
    }

    protected void incrementalBuild(XSDManager man, IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        XSDToolsPlugin.traceLog(Msg.create((String)"Running incremental build on project ").txt(this.getProject().getName()).txt("; delta:").txt(delta.toString()).toString());
        delta.accept((IResourceDeltaVisitor)new XSDResourceVisitor(man));
        man.reloadDirty((ProgressMonitor)new ProgressMonitorAdapter(monitor));
    }

    protected boolean isXSDResource(IResource res) {
        String fe = res.getFileExtension();
        return !res.isDerived() && fe != null && fe.toLowerCase().equals("xsd");
    }

    protected void startupOnInitialize() {
        this.forgetLastBuiltState();
    }

    class XSDResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private XSDManager man;

        public XSDResourceVisitor(XSDManager man) {
            this.man = man;
        }

        public boolean visit(IResource resource) {
            if (XSDBuilder.this.isXSDResource(resource)) {
                this.man.markDirty(XSDBuilder.this.getURI(resource));
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            XSDToolsPlugin.traceLog("visiting " + resource.getFullPath());
            if (XSDBuilder.this.isXSDResource(resource)) {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        this.man.markDirty(XSDBuilder.this.getURI(resource));
                        break;
                    }
                    case 2: {
                        this.man.remove(XSDBuilder.this.getURI(resource));
                    }
                }
            }
            return true;
        }
    }
}

