/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.ProjectInfo;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Change;
import java.sql.Timestamp;

public class ChangeInfo {
    protected Change.Id id;
    protected Change.Key key;
    protected Account.Id owner;
    protected String subject;
    protected Change.Status status;
    protected ProjectInfo project;
    protected String branch;
    protected String topic;
    protected boolean starred;
    protected Timestamp lastUpdatedOn;
    protected String sortKey;

    protected ChangeInfo() {
    }

    public ChangeInfo(Change c) {
        this.id = c.getId();
        this.key = c.getKey();
        this.owner = c.getOwner();
        this.subject = c.getSubject();
        this.status = c.getStatus();
        this.project = new ProjectInfo(c.getProject());
        this.branch = c.getDest().getShortName();
        this.topic = c.getTopic();
        this.lastUpdatedOn = c.getLastUpdatedOn();
        this.sortKey = c.getSortKey();
    }

    public Change.Id getId() {
        return this.id;
    }

    public Change.Key getKey() {
        return this.key;
    }

    public Account.Id getOwner() {
        return this.owner;
    }

    public String getSubject() {
        return this.subject;
    }

    public Change.Status getStatus() {
        return this.status;
    }

    public ProjectInfo getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isStarred() {
        return this.starred;
    }

    public void setStarred(boolean s) {
        this.starred = s;
    }

    public Timestamp getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public String getSortKey() {
        return this.sortKey;
    }
}

