/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.Schema;
import com.google.gwtorm.client.SchemaFactory;
import com.google.gwtorm.jdbc.AbstractSchemaFactory;
import com.google.gwtorm.jdbc.gen.GeneratedClassLoader;
import com.google.gwtorm.jdbc.gen.SchemaFactoryGen;
import com.google.gwtorm.jdbc.gen.SchemaGen;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.java.JavaSchemaModel;
import com.google.gwtorm.schema.sql.DialectH2;
import com.google.gwtorm.schema.sql.DialectMySQL;
import com.google.gwtorm.schema.sql.DialectPostgreSQL;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.StandardKeyEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;

public class Database<T extends Schema>
implements SchemaFactory<T> {
    private static final Map<SchemaKey, String> schemaFactoryNames = Collections.synchronizedMap(new WeakHashMap());
    private final DataSource dataSource;
    private final JavaSchemaModel schemaModel;
    private final AbstractSchemaFactory<T> implFactory;
    private final SqlDialect implDialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(DataSource ds, Class<T> schema) throws OrmException {
        SqlDialect dialect;
        this.dataSource = ds;
        try {
            Connection c = ds.getConnection();
            try {
                String url = c.getMetaData().getURL();
                if (url.startsWith("jdbc:postgresql:")) {
                    dialect = new DialectPostgreSQL();
                } else if (url.startsWith("jdbc:h2:")) {
                    dialect = new DialectH2();
                } else if (url.startsWith("jdbc:mysql:")) {
                    dialect = new DialectMySQL();
                } else {
                    throw new OrmException("No dialect known for " + url);
                }
                dialect = ((SqlDialect)dialect).refine(c);
            }
            finally {
                c.close();
            }
        }
        catch (SQLException e) {
            throw new OrmException("Unable to determine driver URL", e);
        }
        this.schemaModel = new JavaSchemaModel(schema);
        GeneratedClassLoader loader = Database.newLoader(schema);
        SchemaKey key = new SchemaKey(schema, dialect);
        String cachedName = schemaFactoryNames.get(key);
        AbstractSchemaFactory<T> factory = null;
        if (cachedName != null) {
            factory = this.newFactory(loader, cachedName);
        }
        if (factory == null) {
            SchemaGen gen = new SchemaGen(loader, this.schemaModel, dialect);
            gen.defineClass();
            factory = new SchemaFactoryGen(loader, gen).create();
            schemaFactoryNames.put(key, factory.getClass().getName());
        }
        this.implFactory = factory;
        this.implDialect = dialect;
    }

    private AbstractSchemaFactory<T> newFactory(ClassLoader cl, String name) {
        try {
            Class<?> ft = Class.forName(name, true, cl);
            return (AbstractSchemaFactory)ft.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    SqlDialect getDialect() {
        return this.implDialect;
    }

    SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    @Override
    public T open() throws OrmException {
        Connection conn;
        try {
            conn = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new OrmException("Cannot open database connection", e);
        }
        try {
            if (!conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OrmException("Cannot force auto-commit on connection", e);
        }
        return this.implFactory.create(this, conn);
    }

    private static <T> GeneratedClassLoader newLoader(Class<T> schema) {
        return new GeneratedClassLoader(schema.getClassLoader());
    }

    static {
        KeyUtil.setEncoderImpl(new StandardKeyEncoder());
    }

    private static class SchemaKey {
        final Class<?> schema;
        final SqlDialect dialect;

        SchemaKey(Class<?> s, SqlDialect d) {
            this.schema = s;
            this.dialect = d;
        }

        public int hashCode() {
            return this.schema.hashCode() * 31 + this.dialect.getClass().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SchemaKey) {
                SchemaKey a = this;
                SchemaKey b = (SchemaKey)o;
                return a.schema == b.schema && a.dialect.getClass() == b.dialect.getClass();
            }
            return false;
        }
    }
}

