/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.spotify.docker.client.DockerDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json"})
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperProvider.class);
    private static final Function<? super Object, ?> EMPTY_MAP = new Function<Object, Object>(){

        public Object apply(Object input) {
            return Collections.emptyMap();
        }
    };
    private static final SimpleModule MODULE = new SimpleModule();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        return OBJECT_MAPPER;
    }

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    static {
        try {
            MODULE.addSerializer(Set.class, (JsonSerializer)new SetSerializer());
            MODULE.addDeserializer(Set.class, (JsonDeserializer)new SetDeserializer());
            MODULE.addSerializer(ImmutableSet.class, (JsonSerializer)new ImmutableSetSerializer());
            MODULE.addDeserializer(ImmutableSet.class, (JsonDeserializer)new ImmutableSetDeserializer());
            OBJECT_MAPPER.registerModule((Module)new GuavaModule());
            OBJECT_MAPPER.registerModule((Module)MODULE);
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            OBJECT_MAPPER.setDateFormat((DateFormat)((Object)new DockerDateFormat()));
        }
        catch (Throwable t) {
            log.error("Failure during static initialization", t);
            throw t;
        }
    }

    private static class ImmutableSetDeserializer
    extends JsonDeserializer<ImmutableSet> {
        private ImmutableSetDeserializer() {
        }

        public ImmutableSet<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map map = (Map)OBJECT_MAPPER.readValue(jp, Map.class);
            return map == null ? null : ImmutableSet.copyOf(map.keySet());
        }
    }

    private static class ImmutableSetSerializer
    extends JsonSerializer<ImmutableSet> {
        private ImmutableSetSerializer() {
        }

        public void serialize(ImmutableSet value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map map = value == null ? null : Maps.asMap((Set)value, (Function)EMPTY_MAP);
            OBJECT_MAPPER.writeValue(jgen, (Object)map);
        }
    }

    private static class SetDeserializer
    extends JsonDeserializer<Set> {
        private SetDeserializer() {
        }

        public Set<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map map = (Map)OBJECT_MAPPER.readValue(jp, Map.class);
            return map == null ? null : map.keySet();
        }
    }

    private static class SetSerializer
    extends JsonSerializer<Set> {
        private SetSerializer() {
        }

        public void serialize(Set value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map map = value == null ? null : Maps.asMap((Set)value, (Function)EMPTY_MAP);
            OBJECT_MAPPER.writeValue(jgen, (Object)map);
        }
    }
}

