/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoConfiguration;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoPartitionScanner;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class AcceleoFoldingViewer
extends SourceViewer {
    private Object input;
    private IDocument document;

    public AcceleoFoldingViewer(Composite parent, int styles) {
        super(parent, null, styles);
        this.setEditable(false);
        Color background = parent.getDisplay().getSystemColor(29);
        Color foreground = parent.getDisplay().getSystemColor(28);
        this.getTextWidget().setBackground(background);
        this.getTextWidget().setForeground(foreground);
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        this.configure((SourceViewerConfiguration)new AcceleoConfiguration(AcceleoUIActivator.getDefault().getPreferenceStore()));
    }

    public void setInput(Object editorInput) {
        this.input = editorInput;
        this.createDocumentFromInput();
    }

    private void createDocumentFromInput() {
        String text = null;
        if (this.input instanceof String) {
            text = (String)this.input;
        }
        this.document = new Document(text);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new AcceleoPartitionScanner(), AcceleoPartitionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect(this.document);
        this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.setDocument(this.document);
    }

    public boolean hasContent() {
        if (this.document != null) {
            return this.document.get().length() > 0;
        }
        return false;
    }
}

