/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.interpreter;

import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.generation.AcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironmentFactory;
import org.eclipse.acceleo.engine.internal.environment.AcceleoPropertiesLookup;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitor;
import org.eclipse.acceleo.engine.service.AcceleoModulePropertiesAdapter;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoInterpreterStrategy;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterFile;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;

public class AcceleoEvaluationTask
implements Callable<EvaluationResult> {
    private EvaluationContext context;

    public AcceleoEvaluationTask(EvaluationContext context) {
        this.context = context;
    }

    private static EClassifier getOCLType(EcoreEnvironment env, Object obj) {
        OCLStandardLibrary library = env.getOCLStandardLibrary();
        EClassifier oclType = (EClassifier)library.getOclAny();
        if (obj instanceof Number) {
            oclType = obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float ? (EClassifier)library.getReal() : (EClassifier)library.getInteger();
        } else if (obj instanceof String) {
            oclType = (EClassifier)library.getString();
        } else if (obj instanceof Boolean) {
            oclType = (EClassifier)library.getBoolean();
        } else if (obj instanceof EObject) {
            oclType = (EClassifier)env.getUMLReflection().asOCLType((Object)((EObject)obj).eClass());
        } else if (obj instanceof Collection) {
            oclType = obj instanceof LinkedHashSet ? (EClassifier)library.getOrderedSet() : (obj instanceof Set ? (EClassifier)library.getSet() : (obj instanceof Bag ? (EClassifier)library.getBag() : (EClassifier)library.getSequence()));
        }
        return oclType;
    }

    private static EClassifier inferCollectionContentOCLType(EcoreEnvironment env, Collection<?> coll) {
        if (coll.isEmpty()) {
            return (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        HashSet<EClassifier> types = new HashSet<EClassifier>();
        for (Object child : coll) {
            types.add(AcceleoEvaluationTask.getOCLType(env, child));
        }
        Iterator iterator = types.iterator();
        EClassifier elementType = (EClassifier)iterator.next();
        while (iterator.hasNext()) {
            elementType = (EClassifier)env.getUMLReflection().getCommonSuperType((Object)elementType, (Object)((EClassifier)iterator.next()));
        }
        if (elementType == null) {
            elementType = (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        return elementType;
    }

    private static String inferOCLType(Object obj) {
        String oclType = "OCLAny";
        EcoreEnvironment env = (EcoreEnvironment)new EcoreEnvironmentFactory().createEnvironment();
        if (obj instanceof Collection) {
            EClassifier elementType = AcceleoEvaluationTask.inferCollectionContentOCLType(env, (Collection)obj);
            CollectionKind kind = CollectionKind.SEQUENCE_LITERAL;
            if (obj instanceof LinkedHashSet) {
                kind = CollectionKind.ORDERED_SET_LITERAL;
            } else if (obj instanceof Set) {
                kind = CollectionKind.SET_LITERAL;
            } else if (obj instanceof Bag) {
                kind = CollectionKind.BAG_LITERAL;
            }
            oclType = env.getTypeResolver().resolveCollectionType(kind, (Object)elementType).getName();
        } else {
            oclType = AcceleoEvaluationTask.getOCLType(env, obj).getName();
        }
        return oclType;
    }

    @Override
    public EvaluationResult call() throws Exception {
        List<EObject> target;
        this.checkCancelled();
        CompilationResult compilationResult = this.context.getCompilationResult();
        EvaluationResult shortcutResult = null;
        if (compilationResult == null || compilationResult.getCompiledExpression() == null) {
            shortcutResult = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", AcceleoUIMessages.getString("acceleo.interpreter.unresolved.compilation.issue")));
        } else if (compilationResult.getCompiledExpression() instanceof ModuleElement && compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() == 4) {
            shortcutResult = new EvaluationResult(null);
        }
        if (shortcutResult != null) {
            return shortcutResult;
        }
        this.checkCancelled();
        assert (compilationResult != null);
        Object compiledExpression = compilationResult.getCompiledExpression();
        if (compiledExpression instanceof EObject) {
            Module module = null;
            EObject eObject = (EObject)compiledExpression;
            if (eObject instanceof Module) {
                module = (Module)eObject;
            } else {
                EObject parent = eObject.eContainer();
                while (parent != null && !(parent instanceof Module)) {
                    parent = parent.eContainer();
                }
                if (parent instanceof Module) {
                    module = (Module)parent;
                }
            }
            if (module != null) {
                AcceleoModulePropertiesAdapter adapter = new AcceleoModulePropertiesAdapter();
                adapter.addProperty("DISABLE_DYNAMIC_MODULES");
                module.eAdapters().add((Object)adapter);
            }
        }
        if ((target = this.context.getTargetEObjects()) == null) {
            target = Collections.emptyList();
        }
        Object resourceSet = compiledExpression instanceof EObject ? ((EObject)compiledExpression).eResource().getResourceSet() : new ResourceSetImpl();
        for (EObject targetEObject : new ArrayList(target)) {
            if (!targetEObject.eIsProxy()) continue;
            this.checkCancelled();
            EObject resolved = EcoreUtil.resolve((EObject)targetEObject, (ResourceSet)resourceSet);
            if (resolved == null || resolved.eIsProxy()) continue;
            target.remove(targetEObject);
            target.add(resolved);
        }
        EvaluationLogListener evaluationListener = new EvaluationLogListener();
        boolean notificationsState = AcceleoPreferences.areNotificationsEnabled();
        AcceleoPreferences.switchNotifications((boolean)false);
        boolean debugMessagesState = AcceleoPreferences.isDebugMessagesEnabled();
        AcceleoPreferences.switchDebugMessages((boolean)false);
        Platform.addLogListener((ILogListener)evaluationListener);
        try {
            this.checkCancelled();
            Object result = null;
            if (compiledExpression instanceof ModuleElement) {
                ModuleElement moduleElement = (ModuleElement)compiledExpression;
                result = this.evaluateModuleElement(moduleElement, target);
            } else if (compiledExpression instanceof org.eclipse.ocl.ecore.OCLExpression) {
                org.eclipse.ocl.ecore.OCLExpression expression = (org.eclipse.ocl.ecore.OCLExpression)compiledExpression;
                result = this.evaluateOCLExpression(expression, target);
            }
            this.checkCancelled();
            IStatus accumulatedProblems = evaluationListener.getAccumulatedProblems();
            IStatus resultStatus = this.createResultStatus(result);
            if (accumulatedProblems instanceof MultiStatus && accumulatedProblems.getSeverity() != 4) {
                ((MultiStatus)accumulatedProblems).add(resultStatus);
            } else if (accumulatedProblems != null && accumulatedProblems.getSeverity() != 4) {
                accumulatedProblems = new MultiStatus("org.eclipse.acceleo.ide.ui", 1, new IStatus[]{accumulatedProblems, resultStatus}, AcceleoUIMessages.getString("acceleo.interpreter.evaluation.issue"), null);
            } else if (accumulatedProblems == null) {
                accumulatedProblems = resultStatus;
            }
            EvaluationResult evaluationResult = new EvaluationResult(result, accumulatedProblems);
            return evaluationResult;
        }
        finally {
            AcceleoPreferences.switchDebugMessages((boolean)debugMessagesState);
            Platform.removeLogListener((ILogListener)evaluationListener);
            AcceleoPreferences.switchNotifications((boolean)notificationsState);
        }
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    private IStatus createResultStatus(Object result) {
        String oclType = result == null ? "OCLVoid" : AcceleoEvaluationTask.inferOCLType(result);
        String size = null;
        if (result instanceof String) {
            size = String.valueOf(((String)result).length());
        } else if (result instanceof Collection) {
            size = String.valueOf(((Collection)result).size());
        }
        String message = AcceleoUIMessages.getString("acceleo.interpreter.result.type", oclType);
        if (size != null) {
            message = String.valueOf(message) + ' ' + AcceleoUIMessages.getString("acceleo.interpreter.result.size", size);
        }
        return new Status(0, "org.eclipse.acceleo.ide.ui", message);
    }

    private Object evaluateModuleElement(ModuleElement moduleElement, List<EObject> target) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        List variables = this.context.getVariables();
        Iterator<EObject> targetItr = target.iterator();
        EList parameters = Collections.emptyList();
        if (moduleElement instanceof Template) {
            parameters = ((Template)moduleElement).getParameter();
        } else if (moduleElement instanceof Query) {
            parameters = ((Query)moduleElement).getParameter();
        }
        for (Variable param : parameters) {
            boolean found = false;
            Iterator vars = variables.iterator();
            while (!found && vars.hasNext()) {
                org.eclipse.acceleo.ui.interpreter.view.Variable next = (org.eclipse.acceleo.ui.interpreter.view.Variable)vars.next();
                if (!param.getName().equals(next.getName())) continue;
                arguments.add(next.getValue());
                vars.remove();
                found = true;
            }
            if (!found && targetItr.hasNext()) {
                arguments.add(targetItr.next());
                found = true;
            }
            if (found || !"currentModel".equals(param.getName()) || target.size() <= 0) continue;
            arguments.add(EcoreUtil.getRootContainer((EObject)target.get(0)));
        }
        AbstractCollection result = null;
        AcceleoEngine engine = new AcceleoEngine();
        AcceleoInterpreterStrategy strategy = new AcceleoInterpreterStrategy();
        IDebugAST debugger = AcceleoEvaluationVisitor.getDebug();
        AcceleoEvaluationVisitor.setDebug(null);
        try {
            if (moduleElement instanceof Template) {
                result = engine.evaluate((Template)moduleElement, arguments, (IAcceleoGenerationStrategy)strategy, (Monitor)new BasicMonitor());
            } else if (moduleElement instanceof Query) {
                result = engine.evaluate((Query)moduleElement, arguments, (IAcceleoGenerationStrategy)strategy, (Monitor)new BasicMonitor());
            }
        }
        finally {
            try {
                strategy.awaitCompletion();
            }
            catch (InterruptedException e) {
                AcceleoEnginePlugin.log((Exception)e, (boolean)true);
            }
        }
        AcceleoEvaluationVisitor.setDebug((IDebugAST)debugger);
        Map preview = strategy.preparePreview(null);
        LinkedHashSet<InterpreterFile> generatedFiles = null;
        if (preview != null && !preview.isEmpty()) {
            generatedFiles = new LinkedHashSet<InterpreterFile>();
            for (Map.Entry file : preview.entrySet()) {
                generatedFiles.add(new InterpreterFile((String)file.getKey(), (String)file.getValue()));
            }
        }
        if (result != null && generatedFiles != null) {
            if (result instanceof String && ((String)((Object)result)).length() > 0) {
                ArrayList<LinkedHashSet<Object>> actualResult = new ArrayList<LinkedHashSet<Object>>();
                actualResult.add((LinkedHashSet<Object>)result);
                actualResult.addAll(generatedFiles);
                result = actualResult;
            } else {
                result = generatedFiles;
            }
        } else if (result == null) {
            result = generatedFiles;
        }
        return result;
    }

    private Object evaluateOCLExpression(org.eclipse.ocl.ecore.OCLExpression oclExpression, List<EObject> target) {
        Module module = (Module)EcoreUtil.getRootContainer((EObject)oclExpression);
        List listeners = Collections.emptyList();
        AcceleoInterpreterStrategy strategy = new AcceleoInterpreterStrategy();
        AcceleoEnvironmentFactory factory = new AcceleoEnvironmentFactory(null, module, listeners, new AcceleoPropertiesLookup(), (IAcceleoGenerationStrategy)strategy, (Monitor)new BasicMonitor());
        OCL ocl = OCL.newInstance((EnvironmentFactory)factory);
        AcceleoEvaluationVisitor evaluationVisitor = (AcceleoEvaluationVisitor)factory.createEvaluationVisitor(ocl.getEnvironment(), ocl.getEvaluationEnvironment(), ocl.getExtentMap());
        EObject actualArgument = target;
        if (target.size() == 1) {
            actualArgument = target.get(0);
        }
        ocl.getEvaluationEnvironment().add("self", (Object)actualArgument);
        ocl.getEvaluationEnvironment().add("thisEObject", (Object)actualArgument);
        EObject modelRoot = null;
        if (target.size() > 0) {
            modelRoot = EcoreUtil.getRootContainer((EObject)((EObject)target.get(0)));
        }
        ocl.getEvaluationEnvironment().add("currentModel", modelRoot);
        for (org.eclipse.acceleo.ui.interpreter.view.Variable variable : this.context.getVariables()) {
            Object value = variable.getValue();
            if (value instanceof EObject && ((EObject)value).eIsProxy()) {
                value = EcoreUtil.resolve((EObject)((EObject)value), (ResourceSet)oclExpression.eResource().getResourceSet());
            }
            ocl.getEvaluationEnvironment().add(variable.getName(), value);
        }
        IDebugAST debugger = AcceleoEvaluationVisitor.getDebug();
        AcceleoEvaluationVisitor.setDebug(null);
        AbstractCollection result = evaluationVisitor.visitExpression((OCLExpression)oclExpression);
        AcceleoEvaluationVisitor.setDebug((IDebugAST)debugger);
        Map preview = factory.getEvaluationPreview();
        LinkedHashSet<InterpreterFile> generatedFiles = null;
        if (preview != null && !preview.isEmpty()) {
            generatedFiles = new LinkedHashSet<InterpreterFile>();
            for (Map.Entry file : preview.entrySet()) {
                generatedFiles.add(new InterpreterFile((String)file.getKey(), (String)file.getValue()));
            }
        }
        if (result != null && generatedFiles != null) {
            if (result instanceof String && ((String)((Object)result)).length() > 0) {
                ArrayList<LinkedHashSet<Object>> actualResult = new ArrayList<LinkedHashSet<Object>>();
                actualResult.add((LinkedHashSet<Object>)result);
                actualResult.addAll(generatedFiles);
                result = actualResult;
            } else {
                result = generatedFiles;
            }
        } else if (result == null) {
            result = generatedFiles;
        }
        return result;
    }

    protected final class EvaluationLogListener
    implements ILogListener {
        private IStatus evaluationStatus;

        protected EvaluationLogListener() {
        }

        public IStatus getAccumulatedProblems() {
            return this.evaluationStatus;
        }

        public void logging(IStatus status, String plugin) {
            if (status.getPlugin().startsWith("org.eclipse.acceleo") || status.getPlugin().startsWith("org.eclipse.ocl")) {
                this.addStatus(status);
            }
        }

        private void addStatus(IStatus status) {
            if (this.evaluationStatus == null) {
                this.evaluationStatus = status;
            } else if (this.evaluationStatus instanceof MultiStatus) {
                ((MultiStatus)this.evaluationStatus).add(status);
            } else {
                this.evaluationStatus = new MultiStatus("org.eclipse.acceleo.ide.ui", 1, new IStatus[]{this.evaluationStatus}, AcceleoUIMessages.getString("acceleo.interpreter.evaluation.issue"), null);
            }
        }
    }
}

