/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.component;

import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.script.api.attribute.ILabel;
import org.eclipse.birt.chart.script.api.component.IAxis;
import org.eclipse.birt.chart.script.api.component.IMarkerLine;
import org.eclipse.birt.chart.script.api.component.IMarkerRange;
import org.eclipse.birt.chart.script.api.scale.IScale;
import org.eclipse.birt.chart.script.internal.ChartComponentUtil;
import org.eclipse.birt.chart.script.internal.component.MarkerLineImpl;
import org.eclipse.birt.chart.script.internal.component.MarkerRangeImpl;
import org.eclipse.birt.chart.script.internal.scale.ScaleImpl;
import org.eclipse.emf.common.util.EList;

public class AxisImpl
implements IAxis {
    private Axis axis;

    public AxisImpl(Axis axis) {
        this.axis = axis;
    }

    @Override
    public IMarkerLine[] getMarkerLines() {
        EList lines = this.axis.getMarkerLines();
        if (lines == null || lines.isEmpty()) {
            return new IMarkerLine[0];
        }
        IMarkerLine[] array = new IMarkerLine[lines.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = new MarkerLineImpl((MarkerLine)lines.get(i));
            ++i;
        }
        return array;
    }

    @Override
    public IMarkerRange[] getMarkerRanges() {
        EList ranges = this.axis.getMarkerRanges();
        if (ranges == null || ranges.isEmpty()) {
            return new IMarkerRange[0];
        }
        IMarkerRange[] array = new IMarkerRange[ranges.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = new MarkerRangeImpl((MarkerRange)ranges.get(i));
            ++i;
        }
        return array;
    }

    @Override
    public IScale getScale() {
        return ScaleImpl.createScale(this.axis);
    }

    @Override
    public String getType() {
        return this.axis.getType().getName();
    }

    @Override
    public void setType(String type) {
        this.axis.setType(AxisType.getByName((String)type));
    }

    @Override
    public ILabel getTitle() {
        Label title = this.axis.getTitle();
        if (title == null) {
            title = ChartComponentUtil.createEMFLabel();
            this.axis.setTitle(title);
        }
        return ChartComponentUtil.convertLabel(title);
    }

    @Override
    public boolean isVisible() {
        return this.axis.getLineAttributes().isVisible();
    }

    public void setTitle(ILabel title) {
        this.axis.setTitle(ChartComponentUtil.convertILabel(title));
    }

    @Override
    public void setVisible(boolean visible) {
        this.axis.getLineAttributes().setVisible(visible);
    }
}

