/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ICloseable;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.CandidateQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnManager;
import org.eclipse.birt.data.engine.executor.aggregation.IProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.executor.aggregation.ProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.executor.cache.RowResultSet;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.executor.transform.IGroupCalculator;
import org.eclipse.birt.data.engine.executor.transform.ResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.SimpleGroupCalculator;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.IAuxiliaryIndexCreator;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.eclipse.birt.data.engine.script.OnFetchScriptHelper;
import org.eclipse.birt.data.engine.storage.DataSetStore;
import org.eclipse.birt.data.engine.storage.IDataSetWriter;

public class SimpleResultSet
implements IResultIterator {
    private RowResultSet rowResultSet;
    private IResultObject currResultObj;
    private IEventHandler handler;
    private int initialRowCount;
    private int rowCount;
    private StreamWrapper streamsWrapper;
    private OutputStream dataSetStream;
    private DataOutputStream dataSetLenStream;
    private long offset = 4L;
    private long rowCountOffset = 0L;
    private Set<String> resultSetNameSet = null;
    private IBaseQueryDefinition query;
    private IResultClass resultClass;
    private IGroupCalculator groupCalculator;
    private IProgressiveAggregationHelper aggrHelper;
    private boolean isClosed;
    private ICloseable closeable;
    private IDataSetWriter writer;
    private List<IAuxiliaryIndexCreator> auxiliaryIndexCreators;
    private boolean forceLookForward;
    private BaseQuery dataSourceQuery;
    private DataEngineSession session;
    private ComputedColumnHelper ccHelper;
    private FilterByRow filterByRow;
    private List<OnFetchScriptHelper> onFetchEvents;
    private boolean firstRowSaved = false;

    public SimpleResultSet(BaseQuery dataSourceQuery, final ResultSet resultSet, IResultClass resultClass, IEventHandler handler, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        SmartCacheRequest scRequest = new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(resultSet, resultClass), resultClass, false);
        this.closeable = new ICloseable(){

            @Override
            public void close() throws DataException {
                resultSet.close();
            }
        };
        this.handler = handler;
        this.initialize(dataSourceQuery, handler, scRequest, resultClass, groupSpecs, session, forceLookingForward);
    }

    public SimpleResultSet(BaseQuery dataSourceQuery, IDataSetPopulator populator, IResultClass resultClass, IEventHandler handler, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        SmartCacheRequest scRequest = new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(populator), resultClass, false);
        this.closeable = populator instanceof ICloseable ? (ICloseable)((Object)populator) : null;
        this.handler = handler;
        this.initialize(dataSourceQuery, handler, scRequest, resultClass, groupSpecs, session, forceLookingForward);
    }

    public SimpleResultSet(CandidateQuery dataSourceQuery, final ICustomDataSet customDataSet, IResultClass resultClass, IEventHandler handler, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        SmartCacheRequest scRequest = new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(customDataSet), resultClass, false);
        this.closeable = new ICloseable(){

            @Override
            public void close() throws DataException {
                customDataSet.close();
            }
        };
        this.handler = handler;
        this.initialize(dataSourceQuery, handler, scRequest, resultClass, groupSpecs, session, forceLookingForward);
    }

    private void initialize(BaseQuery baseQuery, IEventHandler handler, SmartCacheRequest scRequest, IResultClass resultMetadata, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        this.dataSourceQuery = baseQuery;
        this.query = baseQuery.getQueryDefinition();
        this.session = session;
        this.forceLookForward = forceLookingForward;
        boolean needLookForward = this.needLookingForwardFor1Row(groupSpecs, forceLookingForward);
        this.populateComputedColumnHelper(baseQuery);
        this.populateRowResultSet(handler, scRequest, needLookForward);
        this.populateDataSetColumns(handler, this.query, resultMetadata, groupSpecs, forceLookingForward);
        this.populateAggregationHelper(handler, session, groupSpecs, needLookForward);
        this.populateGroupCalculator(groupSpecs, needLookForward, session, this.rowResultSet.getMetaData(), this.aggrHelper);
    }

    private void populateComputedColumnHelper(BaseQuery baseQuery) {
        if (baseQuery.getFetchEvents() == null) {
            return;
        }
        this.onFetchEvents = new ArrayList<OnFetchScriptHelper>();
        int i = 0;
        while (i < baseQuery.getFetchEvents().size()) {
            IResultObjectEvent event = (IResultObjectEvent)baseQuery.getFetchEvents().get(i);
            if (event instanceof ComputedColumnHelper) {
                this.ccHelper = (ComputedColumnHelper)event;
            } else if (event instanceof OnFetchScriptHelper) {
                this.onFetchEvents.add((OnFetchScriptHelper)event);
            } else if (event instanceof FilterByRow) {
                this.filterByRow = (FilterByRow)event;
            }
            ++i;
        }
    }

    private void updateFetchEventMode(int mode) throws DataException {
        if (this.ccHelper != null) {
            this.ccHelper.setModel(mode);
        }
        if (this.filterByRow != null) {
            this.filterByRow.setWorkingFilterSet(mode == 0 ? 1 : 2);
        }
    }

    private void populateRowResultSet(IEventHandler handler, SmartCacheRequest scRequest, boolean lookingForward) {
        DataSetRuntime runtime = handler.getDataSetRuntime();
        this.rowResultSet = runtime == null ? new RowResultSet(scRequest) : new RowResultSetWithResultSetScope(scRequest, runtime);
    }

    private void populateDataSetColumns(IEventHandler handler, IBaseQueryDefinition query, IResultClass resultClass, IQuery.GroupSpec[] groupSpecs, boolean forceLookingForward) throws DataException {
        this.resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(handler.getAllColumnBindings());
        if (query instanceof IQueryDefinition && ((IQueryDefinition)query).needAutoBinding()) {
            int i = 1;
            while (i <= resultClass.getFieldCount()) {
                this.resultSetNameSet.add(resultClass.getFieldName(i));
                this.resultSetNameSet.add(resultClass.getFieldAlias(i));
                ++i;
            }
        }
    }

    private void populateAggregationHelper(IEventHandler handler, DataEngineSession session, IQuery.GroupSpec[] groupSpecs, boolean lookForward) throws DataException {
        AggrDefnManager manager = new AggrDefnManager(handler.getAggrDefinitions());
        this.aggrHelper = lookForward ? new ProgressiveAggregationHelper(handler.getColumnBindings(), manager, session.getTempDir(), session.getSharedScope(), session.getEngineContext().getScriptContext(), handler.getExecutorHelper()) : new DummyAggregationHelper();
    }

    private void populateGroupCalculator(IQuery.GroupSpec[] groupSpecs, boolean lookForward, DataEngineSession session, IResultClass resultMeta, IProgressiveAggregationHelper aggrHelper) throws DataException {
        this.groupCalculator = lookForward ? new SimpleGroupCalculator(session, groupSpecs, resultMeta) : new DummyGroupCalculator();
        this.groupCalculator.setAggrHelper(aggrHelper);
    }

    private void prepareFirstRow() throws DataException {
        this.currResultObj = this.rowResultSet.next();
        this.groupCalculator.registerCurrentResultObject(this.currResultObj);
        this.groupCalculator.registerNextResultObject(this.rowResultSet);
        this.initialRowCount = this.currResultObj != null ? -1 : 0;
        this.rowCount = this.currResultObj != null ? 1 : 0;
        this.groupCalculator.next(0);
    }

    private boolean needLookingForwardFor1Row(IQuery.GroupSpec[] groupSpecs, boolean forceLookingForward) {
        return forceLookingForward || groupSpecs.length > 0 || this.query.cacheQueryResults();
    }

    public IResultIterator getResultSetIterator() throws DataException {
        IResultIterator itr = this.forceLookForward ? new ResultSetWrapper(this.session, this) : this;
        this.handler.handleEndOfDataSetProcess(itr);
        this.prepareFirstRow();
        if (this.forceLookForward) {
            ((ResultSetWrapper)itr).initialize();
        }
        return itr;
    }

    @Override
    public void close() throws DataException {
        if (this.isClosed) {
            return;
        }
        if (this.closeable != null) {
            this.closeable.close();
            this.closeable = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        this.groupCalculator.close();
        if (this.dataSetStream != null) {
            try {
                if (this.dataSetStream instanceof RAOutputStream) {
                    ((RAOutputStream)this.dataSetStream).seek(this.rowCountOffset);
                    if (!this.firstRowSaved) {
                        IOUtil.writeInt((OutputStream)this.dataSetStream, (int)0);
                    } else {
                        IOUtil.writeInt((OutputStream)this.dataSetStream, (int)this.rowCount);
                    }
                }
                if (this.streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext()) != null) {
                    Map<String, IIndexSerializer> hashes = this.streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext());
                    for (IIndexSerializer hash : hashes.values()) {
                        hash.close();
                    }
                }
                Map<String, StringTable> stringTables = this.streamsWrapper.getOutputStringTable(this.getResultClass());
                for (StringTable stringTable : stringTables.values()) {
                    stringTable.close();
                }
                if (this.streamsWrapper.getStreamManager().hasOutStream(31, 0, 2)) {
                    OutputStream exprValueStream = this.streamsWrapper.getStreamManager().getOutStream(31, 0, 2);
                    if (exprValueStream instanceof RAOutputStream) {
                        ((RAOutputStream)exprValueStream).seek(0L);
                        IOUtil.writeInt((OutputStream)exprValueStream, (int)this.rowCount);
                    }
                    exprValueStream.close();
                }
                this.dataSetStream.close();
                this.dataSetStream = null;
            }
            catch (Exception e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
            this.dataSetStream = null;
        }
        if (this.dataSetLenStream != null) {
            try {
                this.dataSetLenStream.close();
            }
            catch (Exception exception) {}
            this.dataSetLenStream = null;
        }
        if (this.auxiliaryIndexCreators != null) {
            for (IAuxiliaryIndexCreator creator : this.auxiliaryIndexCreators) {
                creator.close();
            }
        }
        this.rowResultSet = null;
        this.ccHelper = null;
        this.aggrHelper = null;
        this.handler = null;
        this.session = null;
        this.filterByRow = null;
        this.dataSourceQuery = null;
        this.resultSetNameSet.clear();
        if (this.onFetchEvents != null) {
            this.onFetchEvents.clear();
        }
        this.isClosed = true;
    }

    @Override
    public void incrementalUpdate(StreamWrapper streamsWrapper, int originalRowCount, boolean isSubQuery) throws DataException {
        this.streamsWrapper = streamsWrapper;
        this.auxiliaryIndexCreators = streamsWrapper.getAuxiliaryIndexCreators();
        try {
            this.writer = DataSetStore.createUpdater(this.streamsWrapper.getStreamManager(), this.getResultClass(), this.handler.getAppContext(), this.session, this.auxiliaryIndexCreators);
            if (this.writer == null) {
                this.dataSetStream = this.streamsWrapper.getStreamManager().getOutStream(21, 0, 2);
                OutputStream dlenStream = this.streamsWrapper.getStreamManager().getOutStream(23, 0, 2);
                if (this.dataSetStream instanceof RAOutputStream) {
                    this.rowCountOffset = ((RAOutputStream)this.dataSetStream).getOffset();
                    ((RAOutputStream)this.dataSetStream).seek(((RAOutputStream)this.dataSetStream).length());
                    this.offset = ((RAOutputStream)this.dataSetStream).getOffset();
                }
                if (dlenStream instanceof RAOutputStream) {
                    ((RAOutputStream)dlenStream).seek(((RAOutputStream)dlenStream).length());
                }
                this.dataSetLenStream = new DataOutputStream(dlenStream);
            }
            this.rowCount += originalRowCount;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private List<IBinding> getRequestColumnMap() {
        try {
            if (DataSetStore.isDataMartStore(this.handler.getAppContext(), this.session)) {
                return null;
            }
        }
        catch (DataException dataException) {}
        return this.query instanceof IQueryDefinition && ((IQueryDefinition)this.query).needAutoBinding() ? null : this.handler.getAllColumnBindings();
    }

    @Override
    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        assert (streamsWrapper == null);
        this.streamsWrapper = streamsWrapper;
        this.auxiliaryIndexCreators = streamsWrapper.getAuxiliaryIndexCreators();
        this.groupCalculator.doSave(streamsWrapper.getStreamManager());
        this.writer = DataSetStore.createWriter(streamsWrapper.getStreamManager(), this.getResultClass(), this.handler.getAppContext(), this.session, this.auxiliaryIndexCreators);
        try {
            if (streamsWrapper.getStreamForResultClass() != null) {
                ((ResultClass)this.populateResultClass(this.getResultClass())).doSave(streamsWrapper.getStreamForResultClass(), this.getRequestColumnMap(), streamsWrapper.getStreamManager().getVersion());
                streamsWrapper.getStreamForResultClass().close();
            }
            if (this.writer == null) {
                this.dataSetStream = this.streamsWrapper.getStreamManager().getOutStream(21, 0, 2);
                this.dataSetLenStream = streamsWrapper.getStreamForDataSetRowLens();
                if (this.dataSetStream instanceof RAOutputStream) {
                    this.rowCountOffset = ((RAOutputStream)this.dataSetStream).getOffset();
                }
                IOUtil.writeInt((OutputStream)this.dataSetStream, (int)this.initialRowCount);
                if (this.auxiliaryIndexCreators != null) {
                    for (IAuxiliaryIndexCreator aIndex : this.auxiliaryIndexCreators) {
                        aIndex.initialize(this.resultClass, this.getExecutorHelper().getScriptable());
                    }
                }
            }
            if (this.currResultObj != null) {
                this.saveDataSetResultSet(this.currResultObj, this.rowCount - 1);
                this.firstRowSaved = true;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private IResultClass populateResultClass(IResultClass meta) throws DataException {
        if (this.resultClass == null) {
            ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
            int i = 1;
            while (i <= meta.getFieldCount()) {
                if (!meta.getFieldName(i).equals("_$$_dte_inner_row_id_$$_")) {
                    list.add(meta.getFieldMetaData(i));
                }
                ++i;
            }
            this.resultClass = new ResultClass(list);
        }
        return this.resultClass;
    }

    @Override
    public void first(int groupingLevel) throws DataException {
    }

    @Override
    public Object getAggrValue(String aggrName) throws DataException {
        return this.aggrHelper.getAggrValue(aggrName, this);
    }

    public IProgressiveAggregationHelper getAggrHelper() throws DataException {
        return this.aggrHelper;
    }

    public Integer[] getGroupIndex() throws DataException {
        if (this.groupCalculator.getStartingGroup() == 0) {
            Object[] result = new Integer[this.groupCalculator.getGroupInstanceIndex().length];
            Arrays.fill(result, (Object)0);
            return result;
        }
        Integer[] groupIndex = this.groupCalculator.getGroupInstanceIndex();
        Integer[] copy = new Integer[groupIndex.length];
        System.arraycopy(groupIndex, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return 0;
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObj;
    }

    @Override
    public int getCurrentResultIndex() throws DataException {
        return this.rowResultSet.getIndex();
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        return this.groupCalculator.getEndingGroup();
    }

    @Override
    public IExecutorHelper getExecutorHelper() {
        return this.handler.getExecutorHelper();
    }

    @Override
    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return null;
    }

    @Override
    public IResultClass getResultClass() throws DataException {
        return this.rowResultSet.getMetaData();
    }

    @Override
    public ResultSetCache getResultSetCache() {
        return null;
    }

    @Override
    public int getRowCount() throws DataException {
        return this.initialRowCount;
    }

    @Override
    public int getStartingGroupLevel() throws DataException {
        return this.groupCalculator.getStartingGroup();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void last(int groupingLevel) throws DataException {
        if (this.getEndingGroupLevel() > groupingLevel) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            if (this.getEndingGroupLevel() > groupingLevel) continue;
            return;
lbl5:
            // 2 sources

            ** while (this.next())
        }
lbl6:
        // 1 sources

    }

    @Override
    public boolean next() throws DataException {
        if (this.currResultObj == null) {
            return false;
        }
        if (!this.firstRowSaved) {
            this.firstRowSaved = true;
            this.saveDataSetResultSet(this.currResultObj, 0);
        }
        this.doNext();
        if (this.currResultObj != null) {
            this.saveDataSetResultSet(this.currResultObj, this.rowCount - 1);
        }
        return this.currResultObj != null;
    }

    private void doNext() throws DataException {
        try {
            this.groupCalculator.registerPreviousResultObject(this.currResultObj);
            this.currResultObj = this.rowResultSet.next();
            this.groupCalculator.registerCurrentResultObject(this.currResultObj);
            this.groupCalculator.registerNextResultObject(this.rowResultSet);
            if (this.currResultObj != null) {
                this.groupCalculator.next(this.rowResultSet.getIndex());
            }
        }
        catch (DataException e) {
            this.currResultObj = null;
            throw e;
        }
        if (this.currResultObj != null) {
            ++this.rowCount;
        }
    }

    private void saveDataSetResultSet(IResultObject rs, int index) throws DataException {
        if (this.streamsWrapper != null && rs != null) {
            try {
                if (this.writer != null) {
                    this.writer.save(this.currResultObj, this.rowCount - 1);
                } else if (this.dataSetStream != null) {
                    int colCount = this.populateResultClass(rs.getResultClass()).getFieldCount();
                    IOUtil.writeLong((DataOutputStream)this.dataSetLenStream, (long)this.offset);
                    this.offset += (long)ResultSetUtil.writeResultObject(new DataOutputStream(this.dataSetStream), this.currResultObj, colCount, this.resultSetNameSet, this.streamsWrapper.getOutputStringTable(this.getResultClass()), this.streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext()), this.rowCount - 1, this.streamsWrapper.getStreamManager().getVersion());
                    if (this.auxiliaryIndexCreators != null) {
                        for (IAuxiliaryIndexCreator creator : this.auxiliaryIndexCreators) {
                            creator.save(this.currResultObj, this.rowCount - 1);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
    }

    public boolean aggrValueAvailable(String aggrName, int index) throws DataException {
        return this.groupCalculator.isAggrAtIndexAvailable(aggrName, index);
    }

    private class DummyAggregationHelper
    implements IProgressiveAggregationHelper {
        private DummyAggregationHelper() {
        }

        @Override
        public void onRow(int startingGroupLevel, int endingGroupLevel, IResultObject ro, int currentRowIndex) throws DataException {
        }

        @Override
        public void close() throws DataException {
        }

        @Override
        public Object getLatestAggrValue(String name) throws DataException {
            return null;
        }

        @Override
        public Object getAggrValue(String name, IResultIterator ri) throws DataException {
            return null;
        }

        @Override
        public List getAggrValues(String name) throws DataException {
            return null;
        }

        @Override
        public boolean hasAggr(String name) throws DataException {
            return false;
        }

        @Override
        public Set<String> getAggrNames() throws DataException {
            return new HashSet<String>();
        }

        @Override
        public IAggrInfo getAggrInfo(String aggrName) throws DataException {
            return null;
        }
    }

    private class DummyGroupCalculator
    implements IGroupCalculator {
        private DummyGroupCalculator() {
        }

        @Override
        public void registerPreviousResultObject(IResultObject previous) {
        }

        @Override
        public void registerCurrentResultObject(IResultObject current) {
        }

        @Override
        public void registerNextResultObject(RowResultSet rowResultSet) throws DataException {
        }

        @Override
        public void next(int rowId) throws DataException {
        }

        @Override
        public int getStartingGroup() throws DataException {
            if (SimpleResultSet.this.rowCount == 1) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getEndingGroup() throws DataException {
            if (SimpleResultSet.this.currResultObj == null) {
                return 0;
            }
            return 1;
        }

        @Override
        public void close() throws DataException {
        }

        @Override
        public void doSave(StreamManager manager) throws DataException {
        }

        @Override
        public void setAggrHelper(IProgressiveAggregationHelper aggrHelper) throws DataException {
        }

        @Override
        public boolean isAggrAtIndexAvailable(String aggrName, int currentIndex) throws DataException {
            return false;
        }

        @Override
        public Integer[] getGroupInstanceIndex() {
            return new Integer[0];
        }
    }

    private class RowResultSetWithDataSetScopeAwareness
    extends RowResultSet {
        private DataSetRuntime runtime;
        private DataSetRuntime.Mode cachedMode;

        public RowResultSetWithDataSetScopeAwareness(SmartCacheRequest smartCacheRequest, DataSetRuntime runtime) {
            super(smartCacheRequest, 0);
            this.runtime = runtime;
        }

        @Override
        protected void beforeNext() throws DataException {
            this.cachedMode = this.runtime.getMode();
            this.runtime.setMode(DataSetRuntime.Mode.DataSet);
        }

        @Override
        protected void afterNext() throws DataException {
            this.runtime.setMode(this.cachedMode);
        }

        @Override
        protected void beforeProcessFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
            SimpleResultSet.this.updateFetchEventMode(0);
        }

        @Override
        protected void afterProcessFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
            SimpleResultSet.this.updateFetchEventMode(1);
        }
    }

    private class RowResultSetWithResultSetScope
    extends RowResultSet {
        private IRowResultSet rowResultSet;
        private IResultObject current;
        private JSResultSetRow savedJSResultSetRow;
        private JSResultSetRow evalJSResultSetRow;
        private DataSetRuntime runtime;
        private IResultClass rsMeta;
        private boolean initialized;

        RowResultSetWithResultSetScope(SmartCacheRequest smartCacheRequest, DataSetRuntime runtime) {
            super(smartCacheRequest);
            this.initialized = false;
            this.rowResultSet = new RowResultSetWithDataSetScopeAwareness(smartCacheRequest, runtime);
            this.runtime = runtime;
            this.rsMeta = smartCacheRequest.getResultClass();
        }

        @Override
        protected IResultObject fetch() throws DataException {
            return this.rowResultSet.next();
        }

        @Override
        protected void beforeProcessFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
            this.initialize();
            SimpleResultSet.this.updateFetchEventMode(1);
            this.runtime.setJSResultSetRow(this.evalJSResultSetRow);
            this.current = resultObject;
            this.removeOnFetchScriptHelper();
        }

        private void removeOnFetchScriptHelper() {
            if (SimpleResultSet.this.dataSourceQuery.getFetchEvents() == null) {
                return;
            }
            SimpleResultSet.this.dataSourceQuery.getFetchEvents().removeAll(SimpleResultSet.this.onFetchEvents);
        }

        private void restoreOnFetchScriptHelper() {
            if (SimpleResultSet.this.dataSourceQuery.getFetchEvents() == null) {
                return;
            }
            SimpleResultSet.this.dataSourceQuery.getFetchEvents().addAll(SimpleResultSet.this.onFetchEvents);
        }

        @Override
        protected void afterProcessFetchEvent(IResultObject rsRow, int currentIndex) throws DataException {
            SimpleResultSet.this.updateFetchEventMode(0);
            this.runtime.setJSResultSetRow(this.savedJSResultSetRow);
            this.restoreOnFetchScriptHelper();
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            if (!(this.runtime.getJSResultRowObject() instanceof JSResultSetRow)) {
                return;
            }
            this.savedJSResultSetRow = (JSResultSetRow)this.runtime.getJSResultRowObject();
            IResultIterator itr = new IResultIterator(){

                @Override
                public IResultClass getResultClass() throws DataException {
                    return RowResultSetWithResultSetScope.this.rsMeta;
                }

                @Override
                public Object getAggrValue(String aggrName) throws DataException {
                    return SimpleResultSet.this.aggrHelper.getAggrValue(aggrName, this);
                }

                @Override
                public IResultObject getCurrentResult() throws DataException {
                    return RowResultSetWithResultSetScope.this.current;
                }

                @Override
                public int getCurrentResultIndex() throws DataException {
                    return RowResultSetWithResultSetScope.this.rowResultSet.getIndex();
                }

                @Override
                public boolean next() throws DataException {
                    return false;
                }

                @Override
                public void first(int groupingLevel) throws DataException {
                }

                @Override
                public void last(int groupingLevel) throws DataException {
                }

                @Override
                public int getCurrentGroupIndex(int groupLevel) throws DataException {
                    return 0;
                }

                @Override
                public int getStartingGroupLevel() throws DataException {
                    return 0;
                }

                @Override
                public int getEndingGroupLevel() throws DataException {
                    return 0;
                }

                @Override
                public void close() throws DataException {
                }

                @Override
                public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
                    return null;
                }

                @Override
                public ResultSetCache getResultSetCache() {
                    return null;
                }

                @Override
                public int getRowCount() throws DataException {
                    return 0;
                }

                @Override
                public IExecutorHelper getExecutorHelper() {
                    return null;
                }

                @Override
                public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
                }

                @Override
                public void incrementalUpdate(StreamWrapper streamsWrapper, int rowCount, boolean isSubQuery) throws DataException {
                }
            };
            this.evalJSResultSetRow = new JSResultSetRow(itr, this.savedJSResultSetRow);
        }
    }
}

