/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;

public class TimeMemberUtil {
    private static ULocale defaultLocale = ULocale.getDefault();
    private static TimeZone timeZone = TimeZone.getDefault();

    public static void setDefaultLocale(ULocale defaultLocale) {
        TimeMemberUtil.defaultLocale = defaultLocale;
    }

    public static void setTimeZone(TimeZone timeZone) {
        TimeMemberUtil.timeZone = timeZone;
    }

    public static ULocale getDefaultLocale() {
        return defaultLocale;
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static TimeMember getCurrentMember(IDimension timeDimension, TimeMember cellTimeMember) {
        return TimeMemberUtil.toMember(timeDimension, null, cellTimeMember);
    }

    private static int getLowestLevelIndex(IDimension timeDimension, TimeMember cellTimeMember) {
        ILevel[] levels = timeDimension.getHierarchy().getLevels();
        String[] levelType = cellTimeMember.getLevelType();
        int i = 0;
        while (i < levels.length) {
            if (levels[i].getLeveType().equals(levelType[levelType.length - 1])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static TimeMember toMember(IDimension timeDimension, Date referenceDate, TimeMember cellTimeMember) {
        ILevel[] levels = timeDimension.getHierarchy().getLevels();
        String[] levelType = null;
        levelType = referenceDate != null ? (levels.length > 1 ? new String[levels.length - 1] : new String[levels.length]) : new String[TimeMemberUtil.getLowestLevelIndex(timeDimension, cellTimeMember) + 1];
        int[] levelValue = new int[levelType.length];
        Calendar cal = TimeMemberUtil.getCalendar(referenceDate);
        int year_woy = 1;
        int year = 1;
        int dayOfMonth = cal.get(5);
        int i = 0;
        while (i < cellTimeMember.getLevelType().length) {
            if ("year".equals(cellTimeMember.getLevelType()[i])) {
                cal.set(1, cellTimeMember.getMemberValue()[i]);
            } else if ("quarter".equals(cellTimeMember.getLevelType()[i])) {
                int month = cal.get(2) % 3 + (cellTimeMember.getMemberValue()[i] - 1) * 3;
                cal.set(5, 1);
                cal.set(2, month);
                if (cal.getActualMaximum(5) > dayOfMonth) {
                    cal.set(5, dayOfMonth);
                } else {
                    cal.set(5, cal.getActualMaximum(5));
                }
            } else if ("month".equals(cellTimeMember.getLevelType()[i])) {
                cal.set(5, 1);
                cal.set(2, cellTimeMember.getMemberValue()[i] - 1);
                if (cal.getActualMaximum(5) > dayOfMonth) {
                    cal.set(5, dayOfMonth);
                } else {
                    cal.set(5, cal.getActualMaximum(5));
                }
            } else if ("day-of-month".equals(cellTimeMember.getLevelType()[i])) {
                cal.set(5, cellTimeMember.getMemberValue()[i]);
            } else if ("day-of-week".equals(cellTimeMember.getLevelType()[i])) {
                cal.set(7, cellTimeMember.getMemberValue()[i]);
            } else if ("day-of-year".equals(cellTimeMember.getLevelType()[i])) {
                cal.set(6, cellTimeMember.getMemberValue()[i]);
            } else if ("week-of-year".equals(cellTimeMember.getLevelType()[i])) {
                year_woy = cal.get(17);
                if (year_woy < (year = cal.get(1))) {
                    cal.set(7, 7);
                } else if (year_woy > year) {
                    cal.set(7, 1);
                }
                cal.set(3, cellTimeMember.getMemberValue()[i]);
            } else if ("week-of-month".equals(cellTimeMember.getLevelType()[i])) {
                year_woy = cal.get(17);
                if (year_woy < (year = cal.get(1))) {
                    cal.set(7, 7);
                } else if (year_woy > year) {
                    cal.set(7, 1);
                }
                cal.set(4, cellTimeMember.getMemberValue()[i]);
            }
            ++i;
        }
        i = 0;
        while (i < levelType.length) {
            levelType[i] = levels[i].getLeveType();
            if ("year".equals(levelType[i])) {
                levelValue[i] = cal.get(1);
            } else if ("quarter".equals(levelType[i])) {
                levelValue[i] = TimeMemberUtil.quarter(cal);
            } else if ("month".equals(levelType[i])) {
                levelValue[i] = cal.get(2) + 1;
            } else if ("day-of-month".equals(levelType[i])) {
                levelValue[i] = cal.get(5);
            } else if ("day-of-week".equals(levelType[i])) {
                levelValue[i] = cal.get(7);
            } else if ("day-of-year".equals(levelType[i])) {
                levelValue[i] = cal.get(6);
            } else if ("week-of-year".equals(levelType[i])) {
                levelValue[i] = cal.get(3);
            } else if ("week-of-month".equals(levelType[i])) {
                levelValue[i] = cal.get(4);
            }
            ++i;
        }
        return new TimeMember(levelValue, levelType);
    }

    public static TimeMember toMember(IDimension timeDimension, Date referenceDate) {
        ILevel[] levels = timeDimension.getHierarchy().getLevels();
        String[] levelType = null;
        levelType = new String[levels.length - 1];
        int[] levelValue = new int[levelType.length];
        Calendar cal = TimeMemberUtil.getCalendar(referenceDate);
        int i = 0;
        while (i < levelType.length) {
            levelType[i] = levels[i].getLeveType();
            if ("year".equals(levelType[i])) {
                levelValue[i] = cal.get(1);
            } else if ("quarter".equals(levelType[i])) {
                levelValue[i] = TimeMemberUtil.quarter(cal);
            } else if ("month".equals(levelType[i])) {
                levelValue[i] = cal.get(2) + 1;
            } else if ("day-of-month".equals(levelType[i])) {
                levelValue[i] = cal.get(5);
            } else if ("day-of-week".equals(levelType[i])) {
                levelValue[i] = cal.get(7);
            } else if ("day-of-year".equals(levelType[i])) {
                levelValue[i] = cal.get(6);
            } else if ("week-of-year".equals(levelType[i])) {
                levelValue[i] = cal.get(3);
            } else if ("week-of-month".equals(levelType[i])) {
                levelValue[i] = cal.get(4);
            }
            ++i;
        }
        return new TimeMember(levelValue, levelType);
    }

    private static int quarter(Calendar cal) {
        int month = cal.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private static Calendar getCalendar(Date d) {
        Calendar c = Calendar.getInstance((TimeZone)timeZone, (ULocale)defaultLocale);
        if (d == null) {
            c.clear();
            c.set(1970, 0, 1);
        } else {
            c.setTime(d);
        }
        return c;
    }
}

