/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.ExtendedItemHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.IMultipleAdapterHelper;
import org.eclipse.birt.report.designer.core.model.LibraryHandleAdapter;
import org.eclipse.birt.report.designer.core.model.ReportDesignHandleAdapter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.AutoTextHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.DataItemHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.GridHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ImageHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.LabelHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.MultipleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableGroupHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TextDataHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TextItemHandleAdapter;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.core.runtime.IAdaptable;

public class HandleAdapterFactory {
    private static HandleAdapterFactory factory = null;
    private Map map = new WeakHashMap();

    private HandleAdapterFactory() {
    }

    public DesignElementHandleAdapter getDesignElementHandleAdapter(Object obj, IModelAdapterHelper mark) {
        Object adapter;
        if (obj instanceof IAdaptable && (adapter = ((IAdaptable)obj).getAdapter(DesignElementHandle.class)) != null) {
            obj = adapter;
        }
        if (obj instanceof ReportItemHandle && mark instanceof IMultipleAdapterHelper) {
            return this.getMultipleAdapter(obj, mark);
        }
        if (obj instanceof ReportDesignHandle) {
            return this.getReportDesignHandleAdapter(obj, mark);
        }
        if (obj instanceof LibraryHandle) {
            return this.getLibraryHandleAdapter(obj, mark);
        }
        if (obj instanceof SimpleMasterPageHandle) {
            return this.getSimpleMasterPageHandleAdapter(obj, mark);
        }
        if (obj instanceof TableHandle) {
            return this.getTableHandleAdapter(obj, mark);
        }
        if (obj instanceof RowHandle) {
            return this.getRowHandleAdapter(obj, mark);
        }
        if (obj instanceof ColumnHandle) {
            return this.getColumnHandleAdapter(obj, mark);
        }
        if (obj instanceof CellHandle) {
            return this.getCellHandleAdapter(obj, mark);
        }
        if (obj instanceof ImageHandle) {
            return this.getImageHandleAdapter(obj, mark);
        }
        if (obj instanceof GridHandle) {
            return this.getGridHandleAdapter(obj, mark);
        }
        if (obj instanceof ListHandle) {
            return this.getListHandleAdapter(obj, mark);
        }
        if (obj instanceof AutoTextHandle) {
            return this.getAutoTextHandleAdapter(obj, mark);
        }
        if (obj instanceof LabelHandle) {
            return this.getLabelHandleAdapter(obj, mark);
        }
        if (obj instanceof TextDataHandle) {
            return this.getTextDataHandleAdapter(obj, mark);
        }
        if (obj instanceof DataItemHandle) {
            return this.getDataItemHandleAdapter(obj, mark);
        }
        if (obj instanceof TextItemHandle) {
            return this.getTextItemHandleAdapter(obj, mark);
        }
        if (obj instanceof ExtendedItemHandle) {
            return this.getExtendedItemHandleAdapter(obj, mark);
        }
        return null;
    }

    private TextDataHandleAdapter getTextDataHandleAdapter(Object obj, IModelAdapterHelper mark) {
        TextDataHandleAdapter retValue = (TextDataHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new TextDataHandleAdapter((ReportItemHandle)((TextDataHandle)obj), mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    private ExtendedItemHandleAdapter getExtendedItemHandleAdapter(Object obj, IModelAdapterHelper mark) {
        ExtendedItemHandleAdapter retValue = (ExtendedItemHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new ExtendedItemHandleAdapter((ReportItemHandle)((ExtendedItemHandle)obj), mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public GridHandleAdapter getGridHandleAdapter(Object obj, IModelAdapterHelper mark) {
        GridHandleAdapter retValue = (GridHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new GridHandleAdapter((GridHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public GridHandleAdapter getGridHandleAdapter(Object obj) {
        return this.getGridHandleAdapter(obj, null);
    }

    public ListHandleAdapter getListHandleAdapter(Object obj, IModelAdapterHelper mark) {
        ListHandleAdapter retValue = (ListHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new ListHandleAdapter((ListHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public ListHandleAdapter getListHandleAdapter(Object obj) {
        return this.getListHandleAdapter(obj, null);
    }

    public static HandleAdapterFactory getInstance() {
        if (factory == null) {
            factory = new HandleAdapterFactory();
        }
        return factory;
    }

    public ReportDesignHandleAdapter getSimpleMasterPageHandleAdapter(Object obj, IModelAdapterHelper mark) {
        return this.getReportDesignHandleAdapter();
    }

    public ReportDesignHandleAdapter getReportDesignHandleAdapter(Object obj) {
        return this.getReportDesignHandleAdapter(obj, null);
    }

    public ReportDesignHandleAdapter getReportDesignHandleAdapter(Object obj, IModelAdapterHelper mark) {
        ReportDesignHandleAdapter retValue = (ReportDesignHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new ReportDesignHandleAdapter((ModuleHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public ReportDesignHandleAdapter getReportDesignHandleAdapter() {
        return this.getReportDesignHandleAdapter(SessionHandleAdapter.getInstance().getReportDesignHandle());
    }

    public LibraryHandleAdapter getLibraryHandleAdapter(Object obj) {
        return this.getLibraryHandleAdapter(obj, null);
    }

    public LibraryHandleAdapter getLibraryHandleAdapter(Object obj, IModelAdapterHelper mark) {
        LibraryHandleAdapter retValue = (LibraryHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new LibraryHandleAdapter((ModuleHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public LibraryHandleAdapter getLibraryHandleAdapter() {
        return this.getLibraryHandleAdapter(SessionHandleAdapter.getInstance().getReportDesignHandle());
    }

    public TableHandleAdapter getTableHandleAdapter(Object obj, IModelAdapterHelper mark) {
        TableHandleAdapter retValue = (TableHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = obj instanceof GridHandle ? new GridHandleAdapter((GridHandle)obj, mark) : new TableHandleAdapter((ReportItemHandle)((TableHandle)obj), mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public TableHandleAdapter getTableHandleAdapter(Object obj) {
        return this.getTableHandleAdapter(obj, null);
    }

    public TableGroupHandleAdapter getTableGroupHandleAdapter(Object obj, IModelAdapterHelper mark) {
        TableGroupHandleAdapter retValue = (TableGroupHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new TableGroupHandleAdapter((TableGroupHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public TableGroupHandleAdapter getTableGroupHandleAdapter(Object obj) {
        return this.getTableGroupHandleAdapter(obj, null);
    }

    public CellHandleAdapter getCellHandleAdapter(Object obj, IModelAdapterHelper mark) {
        CellHandleAdapter retValue = (CellHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new CellHandleAdapter((ReportElementHandle)((CellHandle)obj), mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public CellHandleAdapter getCellHandleAdapter(Object obj) {
        return this.getCellHandleAdapter(obj, null);
    }

    public RowHandleAdapter getRowHandleAdapter(Object obj, IModelAdapterHelper mark) {
        RowHandleAdapter retValue = (RowHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new RowHandleAdapter((RowHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public RowHandleAdapter getRowHandleAdapter(Object obj) {
        return this.getRowHandleAdapter(obj, null);
    }

    public ColumnHandleAdapter getColumnHandleAdapter(Object obj, IModelAdapterHelper mark) {
        ColumnHandleAdapter retValue = (ColumnHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new ColumnHandleAdapter((ColumnHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public ColumnHandleAdapter getColumnHandleAdapter(Object obj) {
        return this.getColumnHandleAdapter(obj, null);
    }

    public ImageHandleAdapter getImageHandleAdapter(Object obj, IModelAdapterHelper mark) {
        ImageHandleAdapter retValue = (ImageHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new ImageHandleAdapter((ImageHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public ImageHandleAdapter getImageHandleAdapter(Object obj) {
        return this.getImageHandleAdapter(obj, null);
    }

    public void remove(Object obj, IModelAdapterHelper mark) {
        Object adapter;
        if (obj instanceof IAdaptable && (adapter = ((IAdaptable)obj).getAdapter(DesignElementHandle.class)) != null) {
            obj = adapter;
        }
        this.removeRelated(obj);
        adapter = (DesignElementHandleAdapter)this.map.get(obj);
        if (adapter != null && (mark == null || ((DesignElementHandleAdapter)adapter).getModelAdaptHelper() == mark)) {
            this.map.remove(obj);
        }
    }

    public void remove(Object obj) {
        this.remove(obj, null);
    }

    private void removeRelated(Object obj) {
        Object handleAdaot = this.map.get(obj);
        if (handleAdaot instanceof TableHandleAdapter) {
            TableHandleAdapter adapt = (TableHandleAdapter)handleAdaot;
            this.removeCollection(adapt.getRows());
            this.removeCollection(adapt.getColumns());
        }
    }

    private void removeCollection(List list) {
        int i = 0;
        while (i < list.size()) {
            this.map.remove(list.get(i));
            ++i;
        }
    }

    public LabelHandleAdapter getLabelHandleAdapter(Object obj, IModelAdapterHelper mark) {
        LabelHandleAdapter retValue = (LabelHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new LabelHandleAdapter((ReportItemHandle)((LabelHandle)obj), mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public AutoTextHandleAdapter getAutoTextHandleAdapter(Object obj, IModelAdapterHelper mark) {
        AutoTextHandleAdapter retValue = (AutoTextHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new AutoTextHandleAdapter((ReportItemHandle)((AutoTextHandle)obj), mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public LabelHandleAdapter getLabelHandleAdapter(Object obj) {
        return this.getLabelHandleAdapter(obj, null);
    }

    public TextItemHandleAdapter getTextItemHandleAdapter(Object obj, IModelAdapterHelper mark) {
        TextItemHandleAdapter retValue = (TextItemHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new TextItemHandleAdapter((TextItemHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public TextItemHandleAdapter getTextItemHandleAdapter(Object obj) {
        return this.getTextItemHandleAdapter(obj, null);
    }

    public TextDataHandleAdapter getTextDataHandleAdapter(Object obj) {
        return this.getTextDataHandleAdapter(obj, null);
    }

    public DataItemHandleAdapter getDataItemHandleAdapter(Object obj, IModelAdapterHelper mark) {
        DataItemHandleAdapter retValue = (DataItemHandleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new DataItemHandleAdapter((DataItemHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public DataItemHandleAdapter getDataItemHandleAdapter(Object obj) {
        return this.getDataItemHandleAdapter(obj, null);
    }

    public MultipleAdapter getMultipleAdapter(Object obj, IModelAdapterHelper mark) {
        MultipleAdapter retValue = (MultipleAdapter)this.map.get(obj);
        if (retValue == null) {
            retValue = new MultipleAdapter((ReportItemHandle)obj, mark);
            this.map.put(obj, retValue);
        }
        return retValue;
    }

    public MultipleAdapter getMultipleAdapter(Object obj) {
        return this.getMultipleAdapter(obj, null);
    }
}

