/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.processor;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.processor.IElementProcessor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;

public abstract class AbstractElementProcessor
implements IElementProcessor {
    private String elementType;

    protected AbstractElementProcessor(String elementType) {
        this.elementType = elementType;
    }

    public String getElementType() {
        return this.elementType;
    }

    protected static ElementFactory getElementFactory() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getElementFactory();
    }

    protected static String getNewName(Object extendedData) {
        String newName = null;
        if (extendedData instanceof String) {
            newName = (String)extendedData;
        } else if (extendedData instanceof Map) {
            newName = (String)((Map)extendedData).get("element name");
        }
        return newName;
    }

    @Override
    public String getCreateTransactionLabel() {
        return MessageFormat.format("Create {0}", this.elementType);
    }

    @Override
    public String getEditeTransactionLabel(DesignElementHandle handle) {
        return MessageFormat.format("Edit {0}", DEUtil.getDisplayLabel((Object)handle));
    }
}

