/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.IDefaultConfigLoader;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.RenderOptionDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigLoaderManager {
    private static final String EXTENSION_CONFIG_LOADER_CONTRIBUTOR = "org.eclipse.birt.report.engine.emitter.config.DefaultConfigLoader";
    private static final DefaultConfigLoaderManager instance = new DefaultConfigLoaderManager();
    private List<IDefaultConfigLoader> loaders = new ArrayList<IDefaultConfigLoader>();

    private DefaultConfigLoaderManager() {
        try {
            this.initLoaders();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static DefaultConfigLoaderManager getInstance() {
        return instance;
    }

    public Map<String, RenderOptionDefn> loadConfigFor(String bundleName, IEmitterDescriptor descriptor) {
        HashMap<String, RenderOptionDefn> renderOptions = new HashMap<String, RenderOptionDefn>();
        for (IDefaultConfigLoader loader : this.getSortedConfigLoaders()) {
            Map<String, RenderOptionDefn> options = loader.loadConfigFor(bundleName, descriptor);
            for (Map.Entry<String, RenderOptionDefn> option : options.entrySet()) {
                renderOptions.put(option.getKey(), option.getValue());
            }
        }
        return renderOptions;
    }

    private List<IDefaultConfigLoader> getSortedConfigLoaders() {
        return Collections.unmodifiableList(this.loaders);
    }

    private void initLoaders() throws FrameworkException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_CONFIG_LOADER_CONTRIBUTOR);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            if (extension != null && (elements = extension.getConfigurationElements()) != null) {
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element != null) {
                        IDefaultConfigLoader loader = (IDefaultConfigLoader)element.createExecutableExtension("class");
                        this.loaders.add(loader);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        Collections.sort(this.loaders, new Comparator<IDefaultConfigLoader>(){

            @Override
            public int compare(IDefaultConfigLoader arg0, IDefaultConfigLoader arg1) {
                return arg0.getPriority() - arg1.getPriority();
            }
        });
    }
}

