/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.GrandTotalProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.SubTotalProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AggregationDialog
extends BaseDialog {
    private static final String DIALOG_NAME = Messages.getString("AggregationDialog.Title");
    private List<SubTotalInfo> rowSubList = new ArrayList<SubTotalInfo>();
    private List<GrandTotalInfo> rowGrandList = new ArrayList<GrandTotalInfo>();
    private List<SubTotalInfo> colSubList = new ArrayList<SubTotalInfo>();
    private List<GrandTotalInfo> colGrandList = new ArrayList<GrandTotalInfo>();
    private TabFolder tabFolder;
    private TabItem rowArea;
    private TabItem columnArea;
    private int currentAxis = -1;
    private CrosstabReportItemHandle crosstab;

    private void setCrosstab(CrosstabReportItemHandle crosstab) {
        this.crosstab = crosstab;
    }

    public AggregationDialog(Shell shell, CrosstabReportItemHandle crosstab) {
        super(shell, DIALOG_NAME);
        this.setCrosstab(crosstab);
    }

    public void setAxis(int axis) {
        this.currentAxis = axis;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CrossTabAggregationDialog_ID");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.createTabFolder(dialogArea);
        int i = 0;
        while (i < 2) {
            Composite content = new Composite((Composite)this.tabFolder, 0);
            content.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            content.setLayout((Layout)layout);
            SubTotalDialog subTotal = new SubTotalDialog();
            if (i == 0) {
                subTotal.setAxis(0);
                subTotal.setInput(this.rowSubList, this.rowGrandList);
            } else if (i == 1) {
                subTotal.setAxis(1);
                subTotal.setInput(this.colSubList, this.colGrandList);
            }
            subTotal.createSubTotalArea(content);
            subTotal.createGrandTotalArea(content);
            subTotal.init();
            this.tabFolder.getItem(i).setControl((Control)content);
            ++i;
        }
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.ini();
        return dialogArea;
    }

    private void ini() {
        if (this.currentAxis == 0) {
            this.tabFolder.setSelection(this.rowArea);
        } else if (this.currentAxis == 1) {
            this.tabFolder.setSelection(this.columnArea);
        }
    }

    private TabFolder createTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.rowArea = new TabItem(this.tabFolder, 0);
        this.rowArea.setText(Messages.getString("AggregationDialog.TabItem.Title.RowArea"));
        this.rowArea.setImage(CrosstabUIHelper.getImage("icons/pal/row-area.gif"));
        this.columnArea = new TabItem(this.tabFolder, 0);
        this.columnArea.setText(Messages.getString("AggregationDialog.TabItem.Title.ColumnArea"));
        this.columnArea.setImage(CrosstabUIHelper.getImage("icons/pal/column-area.gif"));
        return this.tabFolder;
    }

    public void setInput(List<SubTotalInfo> rowSubList, List<GrandTotalInfo> rowGrandList, List<SubTotalInfo> colSubList, List<GrandTotalInfo> colGrandList) {
        this.rowSubList.addAll(rowSubList);
        this.rowGrandList.addAll(rowGrandList);
        this.colSubList.addAll(colSubList);
        this.colGrandList.addAll(colGrandList);
    }

    public Object getResult() {
        return new Object[]{this.rowSubList, this.rowGrandList, this.colSubList, this.colGrandList};
    }

    public static class GrandTotalInfo {
        private String expectedView = "";
        private CrosstabViewHandle viewHandle;
        private String measureQualifiedName = "";
        private String measureDisplayName = "";
        private boolean aggregationOn = false;
        private String function = "";
        private boolean isAssociation = false;

        public GrandTotalInfo copy() {
            GrandTotalInfo retValue = new GrandTotalInfo();
            retValue.setAggregationOn(this.isAggregationOn());
            retValue.setFunction(this.getFunction());
            retValue.setMeasureQualifiedName(this.getMeasureQualifiedName());
            retValue.setMeasureDisplayName(this.getMeasureDisplayName());
            retValue.setAssociation(this.isAssociation());
            retValue.setExpectedView(this.expectedView);
            retValue.setViewHandle(this.getViewHandle());
            retValue.setPosition(this.getPosition());
            return retValue;
        }

        public String getPosition() {
            return this.viewHandle.getGrandTotalLocation();
        }

        public void setPosition(String position) {
            try {
                this.viewHandle.setGrandTotalLocation(position);
            }
            catch (SemanticException semanticException) {}
        }

        public CrosstabViewHandle getViewHandle() {
            return this.viewHandle;
        }

        public void setViewHandle(CrosstabViewHandle viewHandle) {
            this.viewHandle = viewHandle;
        }

        public String getExpectedView() {
            return this.expectedView;
        }

        public void setExpectedView(String expectedView) {
            this.expectedView = expectedView;
        }

        public String getFunction() {
            return this.function;
        }

        public String getMeasureQualifiedName() {
            return this.measureQualifiedName;
        }

        public String getMeasureDisplayName() {
            return this.measureDisplayName;
        }

        public boolean isAggregationOn() {
            return this.aggregationOn;
        }

        public void setAggregationOn(boolean aggregationOn) {
            this.aggregationOn = aggregationOn;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public void setMeasureQualifiedName(String name) {
            this.measureQualifiedName = name;
        }

        public void setMeasureDisplayName(String displayName) {
            this.measureDisplayName = displayName;
        }

        public boolean isSameInfo(Object obj) {
            if (!(obj instanceof GrandTotalInfo)) {
                return false;
            }
            GrandTotalInfo temp = (GrandTotalInfo)obj;
            return temp.getMeasureQualifiedName().equals(this.measureQualifiedName);
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public void setAssociation(boolean isAssociation) {
            this.isAssociation = isAssociation;
        }
    }

    private class SubTotalDialog {
        private CheckboxTableViewer grandTableViewer;
        private CheckboxTableViewer subTableViewer;
        private List<SubTotalInfo> subList;
        private List<GrandTotalInfo> grandList;
        private int axis;

        private SubTotalDialog() {
        }

        public void setInput(List<SubTotalInfo> subList, List<GrandTotalInfo> grandList) {
            this.subList = subList;
            this.grandList = grandList;
        }

        public void setAxis(int axis) {
            this.axis = axis;
        }

        private void init() {
            TableItem item;
            int i;
            if (this.subList != null) {
                this.subTableViewer.setInput(this.subList);
                i = 0;
                while (i < this.subTableViewer.getTable().getItemCount()) {
                    item = this.subTableViewer.getTable().getItem(i);
                    if (item.getData() != null && item.getData() instanceof SubTotalInfo) {
                        item.setChecked(((SubTotalInfo)item.getData()).isAggregationOn());
                    }
                    ++i;
                }
                this.subTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableItem item = (TableItem)e.item;
                        if (item != null && item.getData() != null && item.getData() instanceof SubTotalInfo) {
                            SubTotalInfo info = (SubTotalInfo)item.getData();
                            info.setAggregationOn(item.getChecked());
                            if (info.isAssociation()) {
                                int i = 0;
                                while (i < SubTotalDialog.this.subTableViewer.getTable().getItemCount()) {
                                    TableItem temp = SubTotalDialog.this.subTableViewer.getTable().getItem(i);
                                    if (temp != item && temp.getData() != null && temp.getData() instanceof SubTotalInfo && ((SubTotalInfo)temp.getData()).getLevel() == info.getLevel()) {
                                        temp.setChecked(item.getChecked());
                                        ((SubTotalInfo)temp.getData()).setAggregationOn(item.getChecked());
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                });
            }
            if (this.grandList != null) {
                this.grandTableViewer.setInput(this.grandList);
                i = 0;
                while (i < this.grandTableViewer.getTable().getItemCount()) {
                    item = this.grandTableViewer.getTable().getItem(i);
                    if (item.getData() != null && item.getData() instanceof GrandTotalInfo) {
                        item.setChecked(((GrandTotalInfo)item.getData()).isAggregationOn());
                    }
                    ++i;
                }
                this.grandTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableItem item = (TableItem)e.item;
                        if (item != null && item.getData() != null && item.getData() instanceof GrandTotalInfo) {
                            GrandTotalInfo info = (GrandTotalInfo)item.getData();
                            info.setAggregationOn(item.getChecked());
                            if (info.isAssociation()) {
                                int i = 0;
                                while (i < SubTotalDialog.this.grandTableViewer.getTable().getItemCount()) {
                                    TableItem temp = SubTotalDialog.this.grandTableViewer.getTable().getItem(i);
                                    if (temp != item && temp.getData() != null && temp.getData() instanceof GrandTotalInfo) {
                                        temp.setChecked(item.getChecked());
                                        ((GrandTotalInfo)temp.getData()).setAggregationOn(item.getChecked());
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                });
            }
        }

        private void createGrandTotalArea(Composite content) {
            CLabel grandTotalLabel = new CLabel(content, 0);
            grandTotalLabel.setText(Messages.getString("AggregationDialog.Label.Grand"));
            if (this.axis == 0) {
                grandTotalLabel.setImage(CrosstabUIHelper.getImage("icons/pal/row-grand-total.gif"));
            } else if (this.axis == 1) {
                grandTotalLabel.setImage(CrosstabUIHelper.getImage("icons/pal/col-grand-total.gif"));
            }
            Table table = new Table(content, 68388);
            table.setLinesVisible(false);
            table.setHeaderVisible(true);
            GridData gd = new GridData(1808);
            gd.minimumHeight = 200;
            table.setLayoutData((Object)gd);
            this.grandTableViewer = new CheckboxTableViewer(table);
            GrandTotalProvider provider = new GrandTotalProvider((TableViewer)this.grandTableViewer, AggregationDialog.this.crosstab, this.axis);
            String[] columnNames = provider.getColumnNames();
            int[] columnWidths = provider.columnWidths();
            int i = 0;
            while (i < columnNames.length) {
                TableColumn column = new TableColumn(table, 16384);
                column.setText(columnNames[i]);
                column.setWidth(columnWidths[i]);
                ++i;
            }
            this.grandTableViewer.setUseHashlookup(true);
            this.grandTableViewer.setColumnProperties(provider.getColumnNames());
            this.grandTableViewer.setCellEditors(provider.getCellEditors());
            this.grandTableViewer.setCellModifier((ICellModifier)provider);
            this.grandTableViewer.setCellEditors(provider.getCellEditors());
            this.grandTableViewer.setContentProvider((IContentProvider)provider);
            this.grandTableViewer.setLabelProvider((IBaseLabelProvider)provider);
            this.grandTableViewer.setCellModifier((ICellModifier)provider);
        }

        private void createSubTotalArea(Composite content) {
            CLabel subTotalLabel = new CLabel(content, 0);
            subTotalLabel.setText(Messages.getString("AggregationDialog.Label.Sub"));
            if (this.axis == 0) {
                subTotalLabel.setImage(CrosstabUIHelper.getImage("icons/pal/row-subtotal.gif"));
            } else if (this.axis == 1) {
                subTotalLabel.setImage(CrosstabUIHelper.getImage("icons/pal/col-subtotal.gif"));
            }
            Table table = new Table(content, 68388);
            table.setLinesVisible(false);
            table.setHeaderVisible(true);
            GridData gd = new GridData(1808);
            gd.minimumHeight = 200;
            table.setLayoutData((Object)gd);
            this.subTableViewer = new CheckboxTableViewer(table);
            SubTotalProvider provider = new SubTotalProvider((TableViewer)this.subTableViewer, AggregationDialog.this.crosstab, this.axis);
            String[] columnNames = provider.getColumnNames();
            int[] columnWidths = provider.columnWidths();
            int i = 0;
            while (i < columnNames.length) {
                TableColumn column = new TableColumn(table, 16384);
                column.setText(columnNames[i]);
                column.setWidth(columnWidths[i]);
                ++i;
            }
            this.subTableViewer.setUseHashlookup(true);
            this.subTableViewer.setColumnProperties(provider.getColumnNames());
            this.subTableViewer.setCellEditors(provider.getCellEditors());
            this.subTableViewer.setContentProvider((IContentProvider)provider);
            this.subTableViewer.setLabelProvider((IBaseLabelProvider)provider);
            this.subTableViewer.setCellModifier((ICellModifier)provider);
        }
    }

    public static class SubTotalInfo {
        private String expectedView = "";
        private LevelHandle level;
        private LevelViewHandle levelView;
        private String measureQualifiedName = "";
        private String measureDisplayName = "";
        private boolean aggregationOn = false;
        private boolean isAssociation = false;
        private String function = "";

        public SubTotalInfo copy() {
            SubTotalInfo retValue = new SubTotalInfo();
            retValue.setAggregationOn(this.isAggregationOn());
            retValue.setFunction(this.getFunction());
            retValue.setLevelView(this.getLevelView());
            retValue.setAssociation(this.isAssociation());
            retValue.setExpectedView(this.expectedView);
            retValue.setAggregateOnMeasureName(this.getAggregateOnMeasureName());
            retValue.setAggregateOnMeasureDisplayName(this.getAggregateOnMeasureDisplayName());
            return retValue;
        }

        public String getPosition() {
            return this.levelView.getAggregationHeaderLocation();
        }

        public void setPosition(String pos) {
            try {
                this.levelView.setAggregationHeaderLocation(pos);
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        }

        public String getExpectedView() {
            return this.expectedView;
        }

        public void setExpectedView(String expectedView) {
            this.expectedView = expectedView;
        }

        public String getAggregateOnMeasureName() {
            return this.measureQualifiedName;
        }

        public String getAggregateOnMeasureDisplayName() {
            return this.measureDisplayName;
        }

        public String getFunction() {
            return this.function;
        }

        public LevelHandle getLevel() {
            return this.level;
        }

        public LevelViewHandle getLevelView() {
            return this.levelView;
        }

        public boolean isAggregationOn() {
            return this.aggregationOn;
        }

        public void setAggregateOnMeasureName(String name) {
            this.measureQualifiedName = name;
        }

        public void setAggregateOnMeasureDisplayName(String displayName) {
            this.measureDisplayName = displayName;
        }

        public void setAggregationOn(boolean aggregationOn) {
            this.aggregationOn = aggregationOn;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public void setLevelView(LevelViewHandle levelView) {
            this.levelView = levelView;
            this.level = levelView.getCubeLevel();
        }

        public boolean isSameInfo(Object obj) {
            if (!(obj instanceof SubTotalInfo)) {
                return false;
            }
            SubTotalInfo temp = (SubTotalInfo)obj;
            return temp.getLevel() == this.level && temp.getAggregateOnMeasureName().equals(this.measureQualifiedName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SubTotalInfo)) {
                return false;
            }
            SubTotalInfo temp = (SubTotalInfo)obj;
            return temp.getLevel() == this.level && StringUtil.isEqual((String)temp.getAggregateOnMeasureName(), (String)this.measureQualifiedName) && StringUtil.isEqual((String)temp.getFunction(), (String)this.function) && temp.isAggregationOn() == this.aggregationOn && StringUtil.isEqual((String)temp.getExpectedView(), (String)this.expectedView) && temp.getPosition().equals(this.levelView.getAggregationHeaderLocation());
        }

        public int hashCode() {
            int hash = 31;
            hash = hash * 31 + this.level.hashCode();
            hash = hash * 31 + (this.measureQualifiedName == null ? 0 : this.measureQualifiedName.hashCode());
            return hash;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public void setAssociation(boolean isAssociation) {
            this.isAssociation = isAssociation;
        }
    }
}

