/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoToolSystem;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArduinoTool {
    private String name;
    private String version;
    private List<ArduinoToolSystem> systems;
    private transient ArduinoPackage pkg;

    public ArduinoPackage getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version.replace('+', '_');
    }

    public List<ArduinoToolSystem> getSystems() {
        return this.systems;
    }

    void init(ArduinoPackage pkg) {
        this.pkg = pkg;
        for (ArduinoToolSystem system : this.systems) {
            system.setOwner(this);
        }
    }

    public Path getInstallPath() {
        return this.getPackage().getInstallPath().resolve("tools").resolve(this.getName()).resolve(this.getVersion());
    }

    public boolean isInstalled() {
        return this.getInstallPath().toFile().exists();
    }

    public void install(IProgressMonitor monitor) throws CoreException {
        if (this.isInstalled()) {
            return;
        }
        for (ArduinoToolSystem system : this.systems) {
            if (!system.isApplicable()) continue;
            system.install(monitor);
            return;
        }
        throw new CoreException((IStatus)new Status(4, Activator.getId(), String.format("No valid system found for %s", this.name)));
    }

    public Properties getToolProperties() {
        Properties properties = new Properties();
        properties.put("runtime.tools." + this.name + ".path", ArduinoBuildConfiguration.pathString(this.getInstallPath()));
        properties.put("runtime.tools." + this.name + '-' + this.version + ".path", ArduinoBuildConfiguration.pathString(this.getInstallPath()));
        return properties;
    }
}

