/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.transport.BufferedMemoryWriter;
import org.eclipse.cdt.debug.ui.memory.transport.ImportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SRecordImporter
implements IMemoryImporter {
    File fInputFile;
    BigInteger fStartAddress;
    Boolean fScrollToStart;
    private Text fStartText;
    private Text fFileText;
    private Button fComboRestoreToThisAddress;
    private Button fComboRestoreToFileAddress;
    private Button fScrollToBeginningOnImportComplete;
    private IMemoryBlock fMemoryBlock;
    private ImportMemoryDialog fParentDialog;
    private IDialogSettings fProperties;
    private static final int BUFFER_LENGTH = 65536;

    @Override
    public Control createControl(final Composite parent, IMemoryBlock memBlock, IDialogSettings properties, ImportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                SRecordImporter.this.fProperties.put("File", SRecordImporter.this.fFileText.getText().trim());
                SRecordImporter.this.fProperties.put("Start", SRecordImporter.this.fStartText.getText().trim());
                SRecordImporter.this.fProperties.put("ScrollToStart", SRecordImporter.this.fScrollToBeginningOnImportComplete.getSelection());
                SRecordImporter.this.fProperties.put("CustomStartAddress", SRecordImporter.this.fComboRestoreToThisAddress.getSelection());
                try {
                    if (SRecordImporter.this.fProperties.getBoolean("CustomStartAddress")) {
                        SRecordImporter.this.fStartAddress = SRecordImporter.this.getStartAddress();
                    }
                    SRecordImporter.this.fInputFile = SRecordImporter.this.getFile();
                    SRecordImporter.this.fScrollToStart = SRecordImporter.this.getScrollToStart();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        this.fComboRestoreToFileAddress = new Button(composite, 16);
        this.fComboRestoreToFileAddress.setSelection(true);
        this.fComboRestoreToFileAddress.setText(Messages.getString("SRecordImporter.FileAddressRestore"));
        this.fComboRestoreToFileAddress.setSelection(!this.fProperties.getBoolean("CustomStartAddress"));
        this.fComboRestoreToThisAddress = new Button(composite, 16);
        this.fComboRestoreToThisAddress.setText(Messages.getString("SRecordImporter.CustomAddressRestore"));
        this.fComboRestoreToThisAddress.setSelection(this.fProperties.getBoolean("CustomStartAddress"));
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fComboRestoreToFileAddress);
        this.fComboRestoreToThisAddress.setLayoutData((Object)data);
        this.fStartText = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fComboRestoreToFileAddress);
        data.left = new FormAttachment((Control)this.fComboRestoreToThisAddress);
        data.width = 120;
        this.fStartText.setLayoutData((Object)data);
        this.fComboRestoreToFileAddress.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SRecordImporter.this.validate();
            }
        });
        this.fComboRestoreToThisAddress.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                    SRecordImporter.this.getStartAddress();
                    SRecordImporter.this.validate();
                }
                catch (Exception ex) {
                    SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                    SRecordImporter.this.fParentDialog.setValid(false);
                }
            }
        });
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 2048);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText(Messages.getString("Importer.File"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText(Messages.getString("Importer.Browse"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        String textValue = this.fProperties.get("File");
        this.fFileText.setText(textValue != null ? textValue : "");
        textValue = this.fProperties.get("Start");
        this.fStartText.setText(textValue != null ? textValue : "0x0");
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText(Messages.getString("SRecordImporter.ChooseFile"));
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{Messages.getString("Importer.AllFiles")});
                dialog.setFileName(SRecordImporter.this.fFileText.getText().trim());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    SRecordImporter.this.fFileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + filename);
                }
                SRecordImporter.this.validate();
            }
        });
        this.fStartText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    boolean restoreToAddress = SRecordImporter.this.fComboRestoreToThisAddress.getSelection();
                    if (restoreToAddress) {
                        SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                        SRecordImporter.this.getStartAddress();
                        SRecordImporter.this.validate();
                    } else {
                        try {
                            SRecordImporter.this.getStartAddress();
                            SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                        }
                        catch (Exception ex) {
                            SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                        }
                    }
                }
                catch (Exception ex) {
                    SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                    SRecordImporter.this.validate();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SRecordImporter.this.validate();
            }
        });
        this.fScrollToBeginningOnImportComplete = new Button(composite, 32);
        this.fScrollToBeginningOnImportComplete.setText(Messages.getString("SRecordImporter.ScrollToStart"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton);
        this.fScrollToBeginningOnImportComplete.setLayoutData((Object)data);
        boolean scrollToStart = this.fProperties.getBoolean("ScrollToStart");
        this.fScrollToBeginningOnImportComplete.setSelection(scrollToStart);
        Label spacingLabel = new Label(composite, 0);
        spacingLabel.setText("");
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)this.fScrollToBeginningOnImportComplete);
        spacingLabel.setLayoutData((Object)data);
        Label restrictionLabel = new Label(composite, 0);
        restrictionLabel.setText(Messages.getString("SRecordImporter.32BitLimitationMessage"));
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)spacingLabel);
        restrictionLabel.setLayoutData((Object)data);
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(() -> this.validate());
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        try {
            boolean restoreToAddress = this.fComboRestoreToThisAddress.getSelection();
            if (restoreToAddress) {
                this.getStartAddress();
            }
            if (this.fFileText.getText().trim().length() == 0) {
                isValid = false;
            }
            if (!this.getFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public boolean getScrollToStart() {
        return this.fScrollToBeginningOnImportComplete.getSelection();
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        if (startAddress.bitLength() > 32) {
            throw new NumberFormatException("Start Address is larger than 32 bits");
        }
        return startAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText().trim());
    }

    @Override
    public String getId() {
        return "srecord";
    }

    @Override
    public String getName() {
        return Messages.getString("SRecordImporter.Name");
    }

    @Override
    public void importMemory() {
        Job job = new Job("Memory Import from S-Record File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BufferedMemoryWriter memoryWriter = new BufferedMemoryWriter((IMemoryBlockExtension)SRecordImporter.this.fMemoryBlock, 65536);
                    boolean CHECKSUM_LENGTH = true;
                    BigInteger scrollToAddress = null;
                    BigInteger offset = null;
                    if (!SRecordImporter.this.fProperties.getBoolean("CustomStartAddress")) {
                        offset = BigInteger.ZERO;
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(SRecordImporter.this.fInputFile)));
                    BigInteger jobs = BigInteger.valueOf(SRecordImporter.this.fInputFile.length());
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask(Messages.getString("Importer.ProgressTitle"), jobs.intValue());
                    String line = reader.readLine();
                    int lineNo = 1;
                    while (line != null && !monitor.isCanceled()) {
                        String recordType = line.substring(0, 2);
                        int recordCount = 0;
                        try {
                            recordCount = Integer.parseInt(line.substring(2, 4), 16);
                        }
                        catch (NumberFormatException ex) {
                            return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, String.format(Messages.getString("SRecordImporter.InvalidLineLength"), lineNo), (Throwable)ex);
                        }
                        int bytesRead = 4 + recordCount;
                        int position = 4;
                        int addressSize = 0;
                        BigInteger recordAddress = null;
                        if ("S3".equals(recordType)) {
                            addressSize = 4;
                        } else if ("S1".equals(recordType)) {
                            addressSize = 2;
                        } else if ("S2".equals(recordType)) {
                            addressSize = 3;
                        } else if ("S0".equals(recordType) || "S5".equals(recordType) || "S7".equals(recordType) || "S8".equals(recordType) || "S9".equals(recordType)) {
                            line = reader.readLine();
                            ++lineNo;
                            continue;
                        }
                        try {
                            recordAddress = new BigInteger(line.substring(position, position + addressSize * 2), 16);
                        }
                        catch (NumberFormatException ex) {
                            return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, String.format(Messages.getString("SRecordImporter.InvalidAddress"), lineNo), (Throwable)ex);
                        }
                        recordCount -= addressSize;
                        position += addressSize * 2;
                        if (offset == null) {
                            offset = SRecordImporter.this.fStartAddress.subtract(recordAddress);
                        }
                        recordAddress = recordAddress.add(offset);
                        byte[] data = new byte[recordCount - 1];
                        int i = 0;
                        while (i < data.length) {
                            try {
                                data[i] = new BigInteger(line.substring(position++, position++ + 1), 16).byteValue();
                            }
                            catch (NumberFormatException ex) {
                                return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, String.format(Messages.getString("SRecordImporter.InvalidData"), lineNo), (Throwable)ex);
                            }
                            ++i;
                        }
                        StringBuilder buf = new StringBuilder(line.substring(2));
                        int checksum = 0;
                        int i2 = 0;
                        while (i2 < buf.length()) {
                            BigInteger value = null;
                            try {
                                value = new BigInteger(buf.substring(i2, i2 + 2), 16);
                            }
                            catch (NumberFormatException ex) {
                                return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, String.format(Messages.getString("SRecordImporter.InvalidChecksum"), lineNo), (Throwable)ex);
                            }
                            checksum = (byte)(checksum + value.byteValue());
                            i2 += 2;
                        }
                        if (checksum != -1) {
                            reader.close();
                            monitor.done();
                            return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), String.valueOf(Messages.getString("SRecordImporter.ChecksumFalure")) + line);
                        }
                        if (scrollToAddress == null) {
                            scrollToAddress = recordAddress;
                        }
                        memoryWriter.write(recordAddress.subtract(((IMemoryBlockExtension)SRecordImporter.this.fMemoryBlock).getBigBaseAddress()), data);
                        BigInteger jobCount = BigInteger.valueOf(bytesRead).divide(factor);
                        monitor.worked(jobCount.intValue());
                        line = reader.readLine();
                        ++lineNo;
                    }
                    if (!monitor.isCanceled()) {
                        memoryWriter.flush();
                    }
                    reader.close();
                    monitor.done();
                    if (SRecordImporter.this.fScrollToStart.booleanValue()) {
                        SRecordImporter.this.fParentDialog.scrollRenderings(scrollToAddress);
                    }
                }
                catch (IOException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrReadFile"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrReadFile"), (Throwable)ex);
                }
                catch (DebugException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrWriteTarget"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrWriteTarget"), (Throwable)ex);
                }
                catch (Exception ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Importer.FalureImporting"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Importer.FalureImporting"), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

