/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.xlc.ui.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.xlc.ui.XLCUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;

public class XLCApplicabilityCalculator
implements IOptionApplicability {
    private static final String BUNDLE_NAME = "org/eclipse/cdt/managedbuilder/xlc/ui/properties/applicability.properties";
    private static final String PROP_NAME_VERSION_ORDER = "xlc.applicability.version.order";
    private static final String PROP_VALUE_PLUS = "+";
    private static boolean initialized;
    private static List versionOrder;
    private static Map applicabilityMap;

    public XLCApplicabilityCalculator() {
        if (!initialized) {
            block26: {
                InputStream input;
                block25: {
                    Properties props = null;
                    ClassLoader loader = this.getClass().getClassLoader();
                    input = null;
                    if (loader != null) {
                        input = loader.getResourceAsStream(BUNDLE_NAME);
                    }
                    if (input == null) {
                        input = ClassLoader.getSystemResourceAsStream(BUNDLE_NAME);
                    }
                    try {
                        try {
                            if (input == null) break block25;
                            props = new Properties();
                            props.load(input);
                            Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
                            for (Map.Entry<Object, Object> entry : entrySet) {
                                String[] versions;
                                ArrayList<String> applicList;
                                String key = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                if (value == null) {
                                    value = "";
                                }
                                if (key.equals(PROP_NAME_VERSION_ORDER)) {
                                    versionOrder = new ArrayList();
                                    String[] versions2 = value.split(",");
                                    if (versions2 == null) continue;
                                    int i = 0;
                                    while (i < versions2.length) {
                                        versionOrder.add(versions2[i].trim());
                                        ++i;
                                    }
                                    continue;
                                }
                                if (applicabilityMap == null) {
                                    applicabilityMap = new HashMap();
                                }
                                if ((applicList = (ArrayList<String>)applicabilityMap.get(key)) == null) {
                                    applicList = new ArrayList<String>();
                                    applicabilityMap.put(key, applicList);
                                }
                                boolean hasGreaterOption = false;
                                if (value.endsWith(PROP_VALUE_PLUS)) {
                                    hasGreaterOption = true;
                                    value = value.substring(0, value.length() - PROP_VALUE_PLUS.length());
                                }
                                if ((versions = value.split(",")) != null) {
                                    int i = 0;
                                    while (i < versions.length) {
                                        applicList.add(versions[i].trim());
                                        ++i;
                                    }
                                }
                                if (!hasGreaterOption) continue;
                                applicList.add(PROP_VALUE_PLUS);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            initialized = true;
        }
    }

    private boolean isApplicable(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        IProject project = null;
        if (configuration instanceof IConfiguration) {
            IConfiguration config = (IConfiguration)configuration;
            IManagedProject managedProject = config.getManagedProject();
            project = (IProject)managedProject.getOwner();
        } else if (configuration instanceof IFolderInfo) {
            IFolderInfo folderInfo = (IFolderInfo)configuration;
            IConfiguration config = folderInfo.getParent();
            IManagedProject managedProject = config.getManagedProject();
            project = (IProject)managedProject.getOwner();
        }
        if (project == null) {
            return false;
        }
        String currentVersion = null;
        try {
            currentVersion = project.getPersistentProperty(new QualifiedName("", "XLC_compilerVersion"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (currentVersion == null) {
            IPreferenceStore prefStore = XLCUIPlugin.getDefault().getPreferenceStore();
            currentVersion = prefStore.getString("XLC_compilerVersion");
        }
        if (applicabilityMap == null) {
            return true;
        }
        List applicList = (List)applicabilityMap.get(option.getId());
        if (applicList == null || applicList.isEmpty()) {
            return true;
        }
        if (applicList.contains(currentVersion)) {
            return true;
        }
        String lastOption = (String)applicList.get(applicList.size() - 1);
        if (lastOption != null && lastOption.equals(PROP_VALUE_PLUS)) {
            if (versionOrder == null) {
                return false;
            }
            String validVersion = null;
            int k = applicList.size() - 2;
            while (k >= 0) {
                String version = (String)applicList.get(k);
                if (versionOrder.contains(version)) {
                    validVersion = version;
                    break;
                }
                --k;
            }
            if (validVersion == null) {
                return false;
            }
            if (versionOrder.indexOf(currentVersion) > versionOrder.indexOf(validVersion)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionEnabled(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return this.isApplicable(configuration, holder, option);
    }

    public boolean isOptionUsedInCommandLine(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return this.isApplicable(configuration, holder, option);
    }

    public boolean isOptionVisible(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return this.isApplicable(configuration, holder, option);
    }
}

