/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build.core;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.PlatformObject;
import org.osgi.framework.Version;

public class MSVCToolChain
extends PlatformObject
implements IToolChain {
    private final IToolChainProvider provider;
    private final Path path;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String id;
    private final String arch;
    private final String version;
    private final IEnvironmentVariable pathVar;
    private final IEnvironmentVariable includeVar;
    private final IEnvironmentVariable libVar;
    private final String[] includeDirs;
    private final Map<String, String> symbols;

    public MSVCToolChain(IToolChainProvider provider, Path path) {
        this.provider = provider;
        this.path = path;
        String targetArch = path.getFileName().toString();
        this.arch = targetArch.equalsIgnoreCase("x86") ? "x86" : "x86_64";
        this.id = "msvc." + this.arch;
        this.version = path.getParent().getParent().getParent().getFileName().toString();
        Path kitRoot = Paths.get("C:", "Program Files (x86)", "Windows Kits", "10");
        List<String> versions = Arrays.asList(kitRoot.resolve("lib").toFile().list());
        Collections.sort(versions, (v1, v2) -> {
            Version ver2;
            Version ver1;
            try {
                ver1 = new Version(v1);
            }
            catch (IllegalArgumentException e) {
                return 1;
            }
            try {
                ver2 = new Version(v2);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            return ver2.compareTo(ver1);
        });
        String sdkVersion = versions.iterator().next();
        this.pathVar = new EnvironmentVariable("Path", String.join((CharSequence)File.pathSeparator, path.toString(), kitRoot.resolve("bin").resolve(sdkVersion).resolve(targetArch).toString()), 3, File.pathSeparator);
        this.includeDirs = new String[]{path.getParent().getParent().getParent().resolve("include").toString(), kitRoot.resolve("include").resolve(sdkVersion).resolve("ucrt").toString(), kitRoot.resolve("include").resolve(sdkVersion).resolve("shared").toString(), kitRoot.resolve("include").resolve(sdkVersion).resolve("um").toString(), kitRoot.resolve("include").resolve(sdkVersion).resolve("winrt").toString()};
        this.includeVar = new EnvironmentVariable("INCLUDE", String.join((CharSequence)File.pathSeparator, this.includeDirs), 1, File.pathSeparator);
        this.libVar = new EnvironmentVariable("LIB", String.join((CharSequence)File.pathSeparator, path.getParent().getParent().getParent().resolve("lib").resolve(targetArch).toString(), kitRoot.resolve("lib").resolve(sdkVersion).resolve("ucrt").resolve(targetArch).toString(), kitRoot.resolve("lib").resolve(sdkVersion).resolve("um").resolve(targetArch).toString()), 1, File.pathSeparator);
        this.symbols = new HashMap<String, String>();
        this.symbols.put("_WIN32", "1");
        if (this.arch.equals("x86")) {
            this.symbols.put("_M_IX86", "600");
        } else {
            this.symbols.put("_WIN64", "1");
            this.symbols.put("_M_X64", "100");
        }
        this.symbols.put("_MSC_VER", "1900");
        this.symbols.put("__cdecl", "");
        this.symbols.put("__fastcall", "");
        this.symbols.put("__restrict", "");
        this.symbols.put("__sptr", "");
        this.symbols.put("__stdcall", "");
        this.symbols.put("__unaligned", "");
        this.symbols.put("__uptr", "");
        this.symbols.put("__w64", "");
        this.symbols.put("__clrcall", "");
        this.symbols.put("__thiscall", "");
        this.symbols.put("__vectorcall", "");
        this.symbols.put("__forceinline", "__inline");
        this.symbols.put("__int8", "char");
        this.symbols.put("__int16", "short");
        this.symbols.put("__int32", "int");
        this.symbols.put("__int64", "long long");
        this.symbols.put("__pragma(X)", "");
        this.symbols.put("__nullptr", "nullptr");
        this.symbols.put("__debugbreak()", "0/0");
        this.symbols.put("__LPREFIX(A)", "L\"##A\"");
    }

    public IToolChainProvider getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return "Visual C++";
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        switch (key) {
            case "os": {
                return "win32";
            }
            case "arch": {
                return this.arch;
            }
        }
        return null;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public IEnvironmentVariable[] getVariables() {
        return new IEnvironmentVariable[]{this.pathVar, this.includeVar, this.libVar};
    }

    public IEnvironmentVariable getVariable(String name) {
        switch (name) {
            case "PATH": 
            case "Path": {
                return this.pathVar;
            }
        }
        return null;
    }

    public String[] getErrorParserIds() {
        return new String[]{"org.eclipse.cdt.core.VCErrorParser"};
    }

    public String getBinaryParserId() {
        return "org.eclipse.cdt.core.PE64";
    }

    public Path getCommandPath(Path command) {
        if (command.isAbsolute()) {
            return command;
        }
        return this.path.resolve(command);
    }

    public String[] getCompileCommands() {
        return new String[]{"cl", "cl.exe"};
    }

    public IExtendedScannerInfo getDefaultScannerInfo(IBuildConfiguration buildConfig, IExtendedScannerInfo baseScannerInfo, ILanguage language, URI buildDirectoryURI) {
        return new ExtendedScannerInfo(this.symbols, this.includeDirs);
    }

    public IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, List<String> command, IExtendedScannerInfo baseScannerInfo, IResource resource, URI buildDirectoryURI) {
        HashMap<String, String> symbols = new HashMap<String, String>(this.symbols);
        ArrayList<String> includeDirs = new ArrayList<String>(Arrays.asList(this.includeDirs));
        for (String arg : command) {
            if (!arg.startsWith("-") && !arg.startsWith("/")) continue;
            if (arg.charAt(1) == 'I') {
                includeDirs.add(arg.substring(2));
                continue;
            }
            if (arg.charAt(1) != 'D') continue;
            String[] define = arg.substring(2).split("=");
            if (define.length == 1) {
                symbols.put(define[0], "1");
                continue;
            }
            symbols.put(define[0], define[1]);
        }
        return new ExtendedScannerInfo(symbols, includeDirs.toArray(new String[includeDirs.size()]));
    }

    public IResource[] getResourcesFromCommand(List<String> command, URI buildDirectoryURI) {
        ArrayList<IFile> resources = new ArrayList<IFile>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = command.size() - 1;
        while (i >= 0) {
            block6: {
                URI uri;
                String arg = command.get(i);
                if (arg.startsWith("-") || arg.startsWith("/")) break;
                Path srcPath = Paths.get(arg, new String[0]);
                if (srcPath.isAbsolute()) {
                    uri = srcPath.toUri();
                } else {
                    try {
                        uri = buildDirectoryURI.resolve(arg);
                    }
                    catch (IllegalArgumentException e) {
                        break block6;
                    }
                }
                IFile[] iFileArray = root.findFilesForLocationURI(uri);
                int n = iFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile resource = iFileArray[n2];
                    resources.add(resource);
                    ++n2;
                }
            }
            --i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

