/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.provider;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.internal.qt.core.QtInstall;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallProvider;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.Platform;

public class QtInstallProvider
implements IQtInstallProvider {
    private static boolean isWin32 = Platform.getOS().equals("win32");

    @Override
    public Collection<IQtInstall> getInstalls() {
        Path root = this.getQtRoot();
        Path qmake = Paths.get(isWin32 ? "bin/qmake.exe" : "bin/qmake", new String[0]);
        if (root != null && Files.exists(root, new LinkOption[0])) {
            try {
                return Files.walk(root, 2, new FileVisitOption[0]).filter(path2 -> Files.exists(path2.resolve(qmake), new LinkOption[0])).map(path2 -> {
                    QtInstall install = new QtInstall(path2.resolve(qmake));
                    if (isWin32 && "win32-g++".equals(install.getSpec())) {
                        install.setProperty("package", "qt");
                    }
                    return install;
                }).collect(Collectors.toList());
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private Path getQtRoot() {
        if (isWin32) {
            String subkey;
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            int i = 0;
            while ((subkey = registry.getCurrentUserKeyName(uninstallKey, i)) != null) {
                String compKey = String.valueOf(uninstallKey) + '\\' + subkey;
                String displayName = registry.getCurrentUserValue(compKey, "DisplayName");
                if ("Qt".equals(displayName)) {
                    String installLocation = registry.getCurrentUserValue(compKey, "InstallLocation");
                    return Paths.get(installLocation, new String[0]);
                }
                ++i;
            }
        } else {
            Path qtDir = Paths.get(System.getProperty("user.home"), "Qt");
            if (Files.exists(qtDir, new LinkOption[0])) {
                return qtDir;
            }
        }
        return null;
    }
}

