/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.pro.parser;

import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.ui.pro.parser.QtProjectFileParser;
import org.eclipse.cdt.internal.qt.ui.pro.parser.QtProjectVariable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class QtProjectFileModifier {
    private QtProjectFileParser parser;
    private IDocument document;

    public QtProjectFileModifier(IDocument doc) {
        if (doc == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        this.document = doc;
        this.parser = new QtProjectFileParser(doc);
    }

    public QtProjectFileModifier(QtProjectFileParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser cannot be null");
        }
        this.document = parser.getDocument();
        this.parser = parser;
    }

    public boolean replaceVariableValue(String variable, String oldValue, String newValue) {
        return this.replaceVariableValue(variable, oldValue, newValue, true);
    }

    public boolean replaceVariableValue(String variable, String oldValue, String newValue, boolean matchWholeLine) {
        QtProjectVariable var = this.parser.getVariable(variable);
        if (var != null) {
            if (matchWholeLine) {
                int line = var.getValueIndex(oldValue);
                if (line >= 0) {
                    return this.replaceVariableValue(var, line, newValue);
                }
            } else {
                int line = 0;
                for (String value : var.getValues()) {
                    int offset = value.indexOf(oldValue);
                    if (offset >= 0) {
                        return this.replaceVariableValue(var, line, var.getValueOffsetForLine(line) + offset, oldValue.length(), newValue);
                    }
                    ++line;
                }
            }
        }
        return false;
    }

    private boolean replaceVariableValue(QtProjectVariable var, int lineNo, String newValue) {
        int offset = var.getValueOffsetForLine(lineNo);
        String value = var.getValueForLine(lineNo);
        int length = value.length();
        return this.replaceVariableValue(var, lineNo, offset, length, newValue);
    }

    private boolean replaceVariableValue(QtProjectVariable var, int lineNo, int offset, int length, String newValue) {
        try {
            this.document.replace(offset, length, newValue);
            return true;
        }
        catch (BadLocationException e) {
            Activator.log((Throwable)e);
            return false;
        }
    }

    public void addVariableValue(String variable, String value) {
        QtProjectVariable var = this.parser.getVariable(variable);
        if (var != null) {
            if (var.getValueIndex(value) < 0) {
                int line = var.getNumberOfLines() - 1;
                String indent = var.getIndentString(line);
                int offset = var.getEndOffset();
                if (var.getLine(line).endsWith("\n")) {
                    --offset;
                }
                try {
                    this.document.replace(offset, 0, "\n" + indent + value);
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
                try {
                    offset = var.getLineEscapeReplacementOffset(line);
                    String lineEscape = var.getLineEscapeReplacementString(line);
                    this.document.replace(offset, 0, lineEscape);
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
            }
        } else {
            String baseVariable = String.valueOf(variable) + " += " + value + "\n";
            if (this.document.get().trim().isEmpty()) {
                try {
                    this.document.replace(0, this.document.getLength(), baseVariable);
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
            } else if (this.document.get().endsWith("\n")) {
                try {
                    this.document.replace(this.document.getLength(), 0, "\n" + baseVariable);
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
            } else {
                try {
                    this.document.replace(this.document.getLength(), 0, "\n\n" + baseVariable);
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
            }
        }
    }

    public void removeVariableValue(String variable, String value) {
        QtProjectVariable var = this.parser.getVariable(variable);
        if (var != null) {
            int line = var.getValueIndex(value);
            if (line == 0 && var.getNumberOfLines() > 1) {
                int offset = var.getValueOffsetForLine(line);
                int end = var.getValueOffsetForLine(line + 1);
                try {
                    this.document.replace(offset, end - offset, "");
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
            } else if (line >= 0) {
                int offset = var.getLineOffset(line);
                int length = var.getLine(line).length();
                if (line > 0) {
                    --offset;
                    ++length;
                }
                try {
                    this.document.replace(offset, length, "");
                }
                catch (BadLocationException e) {
                    Activator.log((Throwable)e);
                }
                if (line > 0 && line == var.getNumberOfLines() - 1) {
                    try {
                        offset = var.getLineEscapeOffset(line - 1);
                        length = var.getLineEscapeEnd(line - 1) - offset;
                        this.document.replace(offset, length, "");
                    }
                    catch (BadLocationException e) {
                        Activator.log((Throwable)e);
                    }
                }
            }
        }
    }

    public IDocument getDocument() {
        return this.document;
    }
}

