/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class CPreview {
    protected final SimpleCSourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    protected Map<String, String> fWorkingValues;
    private int fTabSize = 0;
    private WhitespaceCharacterPainter fWhitespaceCharacterPainter;

    public CPreview(Map<String, String> workingValues, Composite parent) {
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        this.fPreviewDocument = new Document();
        this.fWorkingValues = workingValues;
        tools.setupCDocumentPartitioner((IDocument)this.fPreviewDocument, "___c_partitioning", null);
        PreferenceStore prioritizedSettings = new PreferenceStore();
        IPreferenceStore[] chain = new IPreferenceStore[]{prioritizedSettings, CUIPlugin.getDefault().getCombinedPreferenceStore()};
        this.fPreferenceStore = new ChainedPreferenceStore(chain);
        this.fSourceViewer = new CSourceViewer(parent, null, null, false, 2824, this.fPreferenceStore);
        this.fViewerConfiguration = new SimpleCSourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, null, "___c_partitioning", true);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(tools.getColorManager().getColor(rgb));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new CSourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        String value = this.fWorkingValues.get("org.eclipse.cdt.core.formatter.lineSplit");
        int lineWidth = CPreview.getPositiveIntValue(value, 0);
        this.fMarginPainter.setMarginRulerColumn(lineWidth);
        int tabSize = CPreview.getPositiveIntValue(this.fWorkingValues.get("org.eclipse.cdt.core.formatter.tabulation.size"), 0);
        if (tabSize != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(tabSize);
        }
        this.fTabSize = tabSize;
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public Map<String, String> getWorkingValues() {
        return this.fWorkingValues;
    }

    public void setWorkingValues(Map<String, String> workingValues) {
        this.fWorkingValues = workingValues;
    }

    public void showInvisibleCharacters(boolean enable) {
        if (enable) {
            if (this.fWhitespaceCharacterPainter == null) {
                this.fWhitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)this.fSourceViewer);
                this.fSourceViewer.addPainter((IPainter)this.fWhitespaceCharacterPainter);
            }
        } else {
            this.fSourceViewer.removePainter((IPainter)this.fWhitespaceCharacterPainter);
            this.fWhitespaceCharacterPainter = null;
        }
    }

    private final class CSourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.cdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
                    ((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fSourceViewer.getTextWidget().setFont(font);
                    if (((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fMarginPainter != null) {
                        ((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fViewerConfiguration.affectsTextPresentation(event)) {
                    ((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fViewerConfiguration.handlePropertyChangeEvent(event);
                    ((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fSourceViewer.invalidateTextPresentation();
                }
            }
        };

        public CSourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            CPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            CPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener(CSourcePreviewerUpdater.this.fontListener);
                    ((CSourcePreviewerUpdater)CSourcePreviewerUpdater.this).CPreview.this.fPreferenceStore.removePropertyChangeListener(CSourcePreviewerUpdater.this.propertyListener);
                }
            });
        }
    }
}

