/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.enablement.ibm.catalog.ICatalogAuthorizationIdentifier;
import org.eclipse.datatools.enablement.ibm.ddl.DdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationMessages;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.ddl.ModelValidationProvider;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactAnalyst;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactDescription;
import org.eclipse.datatools.enablement.ibm.util.EngineeringOptionID;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EObject;

public abstract class CoreDdlGenerator
implements DDLGenerator {
    protected Set<SQLObject> suppressCreateElementSet = null;

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        this.accessControlInitialize(elements, progressMonitor);
        return this.generateDDL(elements, progressMonitor, null);
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.createSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.dropSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] generateDDL(SQLObject[] elements, SQLObject[] impacts, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.accessControlInitialize(elements, progressMonitor);
        Vector<SQLObject> v = new Vector<SQLObject>(Arrays.asList(elements));
        Vector<SQLObject> v_impacts = new Vector<SQLObject>(Arrays.asList(impacts));
        int i = 0;
        while (i < v_impacts.size()) {
            SQLObject impact = v_impacts.elementAt(i);
            if (!v.contains(impact)) {
                this.calculateDependency(v, v_impacts, impact);
            }
            ++i;
        }
        Object[] allElements = new SQLObject[v.size()];
        v.copyInto(allElements);
        return this.generateDDL((SQLObject[])allElements, progressMonitor, callback);
    }

    public String[] createSQLObjects(SQLObject[] elements, SQLObject[] impacts, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        Vector<SQLObject> v = new Vector<SQLObject>(Arrays.asList(elements));
        Vector<SQLObject> v_impacts = new Vector<SQLObject>(Arrays.asList(impacts));
        int i = 0;
        while (i < v_impacts.size()) {
            SQLObject impact = v_impacts.elementAt(i);
            if (!v.contains(impact)) {
                this.calculateDependency(v, v_impacts, impact);
            }
            ++i;
        }
        Object[] allElements = new SQLObject[v.size()];
        v.copyInto(allElements);
        EngineeringOption[] options = this.getOptions((SQLObject[])allElements);
        return this.createSQLObjects((SQLObject[])allElements, EngineeringOptionID.generateQuotedIdentifiers(options), EngineeringOptionID.generateFullyQualifiedNames(options), progressMonitor, callback);
    }

    public String[] dropSQLObjects(SQLObject[] elements, SQLObject[] impacts, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        Vector<SQLObject> v = new Vector<SQLObject>(Arrays.asList(elements));
        Vector<SQLObject> v_impacts = new Vector<SQLObject>(Arrays.asList(impacts));
        int i = 0;
        while (i < v_impacts.size()) {
            SQLObject impact = v_impacts.elementAt(i);
            if (!v.contains(impact)) {
                this.calculateDependency(v, v_impacts, impact);
            }
            ++i;
        }
        Object[] allElements = new SQLObject[v.size()];
        v.copyInto(allElements);
        EngineeringOption[] options = this.getOptions((SQLObject[])allElements);
        return this.dropSQLObjects((SQLObject[])allElements, EngineeringOptionID.generateQuotedIdentifiers(options), EngineeringOptionID.generateFullyQualifiedNames(options), progressMonitor, callback);
    }

    public String[] alterTableDropColumn(SQLObject[] columns, SQLObject[] impacts, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        return null;
    }

    private void calculateDependency(Vector v, Vector impacts, SQLObject currentImpact) {
        for (Dependency dependency : currentImpact.getDependencies()) {
            SQLObject targetEnd = (SQLObject)dependency.getTargetEnd();
            if (!impacts.contains(targetEnd)) continue;
            this.calculateDependency(v, impacts, targetEnd);
        }
        v.add(currentImpact);
    }

    protected boolean checkModel(SQLObject[] sqlObjects, EngineeringOption[] options) {
        boolean ret = true;
        if (!EngineeringOptionID.checkModel(options)) {
            return ret;
        }
        ModelValidationProvider provider = DdlGenerationUtility.getModelValidationProvider();
        if (provider != null) {
            ret = provider.checkModel(sqlObjects);
        }
        return ret;
    }

    protected EngineeringOption[] getSelectedOptions(SQLObject[] elements) {
        return this.getOptions(elements);
    }

    protected void accessControlInitialize(SQLObject[] elements, IProgressMonitor progressMonitor) {
        EngineeringOption[] options = this.getSelectedOptions(elements);
        int j = 0;
        while (j < options.length) {
            if (options[j].getId().equals("GENERATE_PRIVILEGE")) {
                if (options[j].getBoolean()) {
                    int i = 0;
                    while (i < elements.length) {
                        SQLObject element = elements[i];
                        if (element instanceof ICatalogAuthorizationIdentifier) {
                            String type = element.eClass().getName();
                            String name = " <" + type + "> " + element.getName();
                            progressMonitor.subTask(String.valueOf(DdlGenerationMessages.LOADING_PRIVILEGES_PROGRESS) + name);
                            ((ICatalogAuthorizationIdentifier)element).getCatalogReceivedPrivileges();
                            progressMonitor.subTask(null);
                        }
                        ++i;
                    }
                } else {
                    return;
                }
            }
            ++j;
        }
    }

    public DdlBuilder getDdlBuilder() {
        return null;
    }

    public void suppressCreate(SQLObject element) {
        if (this.suppressCreateElementSet == null) {
            this.suppressCreateElementSet = new HashSet<SQLObject>();
        }
        this.suppressCreateElementSet.add(element);
    }

    public void suppressCreate(Set<SQLObject> elements) {
        if (this.suppressCreateElementSet == null) {
            this.suppressCreateElementSet = new HashSet<SQLObject>();
        }
        this.suppressCreateElementSet.addAll(elements);
    }

    protected Set<SQLObject> removeCreateSuppressedElements(Set<SQLObject> elements) {
        if (this.suppressCreateElementSet == null) {
            return elements;
        }
        elements.removeAll(this.suppressCreateElementSet);
        return elements;
    }

    protected Set sortDependency(Collection set) {
        LinkedHashSet sorted = new LinkedHashSet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            this.dependencySorting(sorted, set, (EObject)iter.next());
        }
        return sorted;
    }

    private void dependencySorting(LinkedHashSet sorted, Collection orginalSet, EObject object) {
        DependencyImpactAnalyst depAnalayst;
        DependencyImpactDescription[] array;
        if (sorted.contains(object)) {
            return;
        }
        if (this.enableDependency(object) && (array = (depAnalayst = DependencyImpactAnalyst.getInstance()).getDirectDependencies(object)) != null && array.length > 0) {
            int i = array.length - 1;
            while (i >= 0) {
                DependencyImpactDescription depend = array[i];
                EObject targetType = depend.getTarget();
                if (orginalSet.contains(targetType) && !sorted.contains(targetType)) {
                    this.dependencySorting(sorted, orginalSet, targetType);
                }
                --i;
            }
        }
        sorted.add(object);
    }

    protected Set sortImpact(Collection set) {
        LinkedHashSet sorted = new LinkedHashSet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            this.impactSorting(sorted, set, (EObject)iter.next());
        }
        DependencyImpactAnalyst depAnalayst = DependencyImpactAnalyst.getInstance();
        depAnalayst.clearDependencyMap();
        return sorted;
    }

    private void impactSorting(LinkedHashSet sorted, Collection orginalSet, EObject object) {
        DependencyImpactAnalyst depAnalayst;
        DependencyImpactDescription[] array;
        if (sorted.contains(object)) {
            return;
        }
        if (this.enableDependency(object) && (array = (depAnalayst = DependencyImpactAnalyst.getInstance()).getDirectImpacted2(object)) != null && array.length > 0) {
            int i = array.length - 1;
            while (i >= 0) {
                DependencyImpactDescription depend = array[i];
                EObject targetType = depend.getTarget();
                if (orginalSet.contains(targetType) && !sorted.contains(targetType)) {
                    this.impactSorting(sorted, orginalSet, targetType);
                }
                --i;
            }
        }
        sorted.add(object);
    }

    protected boolean enableDependency(EObject object) {
        return false;
    }
}

