/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug;

import java.util.regex.Pattern;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;

public class RubyFilenameLinenumberResolver
implements IDynamicVariableResolver {
    private static final String DEVICE = "(?:[a-zA-Z]:)?";
    private static final String SEPARATOR = "[/\\\\]";
    private static final String SEGMENT = "[ _\\p{L}\\p{N}\\p{M}\\p{S}\\.\\-]+";
    private static final String LINE_NUMBER = "(\\d+)";

    public String resolveValue(IDynamicVariable variable, String argument) {
        StringBuffer sb = new StringBuffer(128);
        sb.append('(');
        sb.append(DEVICE);
        sb.append(SEPARATOR).append('?');
        sb.append(SEGMENT);
        sb.append("(?:").append(SEPARATOR).append(SEGMENT).append(")*");
        sb.append(')');
        sb.append(':');
        sb.append(LINE_NUMBER);
        return sb.toString();
    }

    public static Pattern createPattern() {
        return Pattern.compile(RubyFilenameLinenumberResolver.getRegex());
    }

    public static String getRegex() {
        return new RubyFilenameLinenumberResolver().resolveValue(null, null);
    }
}

