/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.fastdebugger;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.launching.DebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;
import org.eclipse.dltk.ruby.fastdebugger.FastDebuggerPlugin;
import org.eclipse.dltk.ruby.fastdebugger.Messages;
import org.eclipse.dltk.ruby.internal.launching.RubyGenericInstallType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class FastDebuggerRunner
extends DebuggingEngineRunner {
    public static final String ENGINE_ID = "org.eclipse.dltk.ruby.fastdebugger";
    private static final String RUBY_HOST_VAR = "DBGP_RUBY_HOST";
    private static final String RUBY_PORT_VAR = "DBGP_RUBY_PORT";
    private static final String RUBY_KEY_VAR = "DBGP_RUBY_KEY";
    private static final String RUBY_LOG_VAR = "DBGP_RUBY_LOG";
    private static final String DEBUGGER_SCRIPT = "FastRunner.rb";
    private static final String P_CHECK_RUBY_DEBUG = "check_ruby_debug";

    protected IPath deploy(IDeployment deployment) throws CoreException {
        try {
            IPath deploymentPath = FastDebuggerPlugin.getDefault().deployDebuggerSource(deployment);
            return deployment.getFile(deploymentPath).getPath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, ENGINE_ID, Messages.FastDebuggerRunner_unableToDeployDebuggerSource, (Throwable)e));
        }
    }

    public FastDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate, ILaunch launch) throws CoreException {
        if (!(this.getInstall().getInterpreterInstallType() instanceof RubyGenericInstallType)) {
            throw new DebugException((IStatus)new Status(4, ENGINE_ID, Messages.FastDebuggerRunner_fastDebuggerCanOnlyBeRunWithGenericRubyInterpreter));
        }
        IEnvironment env = this.getInstall().getEnvironment();
        IExecutionEnvironment exeEnv = (IExecutionEnvironment)env.getAdapter(IExecutionEnvironment.class);
        IDeployment deployment = exeEnv.createDeployment();
        if (deployment == null) {
            return null;
        }
        DeploymentManager.getInstance().addDeployment(launch, deployment);
        IPath sourceLocation = this.deploy(deployment);
        IPath scriptFile = sourceLocation.append(DEBUGGER_SCRIPT);
        InterpreterConfig newConfig = (InterpreterConfig)config.clone();
        newConfig.addInterpreterArg("-r");
        newConfig.addInterpreterArg(env.convertPathToString(scriptFile));
        newConfig.addInterpreterArg("-I");
        newConfig.addInterpreterArg(env.convertPathToString(sourceLocation));
        DbgpConnectionConfig dbgpConfig = DbgpConnectionConfig.load((InterpreterConfig)config);
        newConfig.addEnvVar(RUBY_HOST_VAR, dbgpConfig.getHost());
        newConfig.addEnvVar(RUBY_PORT_VAR, Integer.toString(dbgpConfig.getPort()));
        String sessionId = dbgpConfig.getSessionId();
        newConfig.addEnvVar(RUBY_KEY_VAR, sessionId);
        String logFileName = this.getLogFileName(delegate, sessionId);
        if (logFileName != null) {
            newConfig.addEnvVar(RUBY_LOG_VAR, logFileName);
        }
        boolean check = delegate.getBoolean(ENGINE_ID, P_CHECK_RUBY_DEBUG);
        newConfig.setProperty(P_CHECK_RUBY_DEBUG, (Object)check);
        return newConfig;
    }

    protected String getDebuggingEngineId() {
        return ENGINE_ID;
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.dltk.ruby.debug";
    }

    public IPath resolveGemsPath(boolean user) {
        IEnvironment env = this.getInstall().getEnvironment();
        Path gemsPath = new Path(this.getInstall().getInstallLocation().toOSString());
        if (gemsPath.segmentCount() < 2) {
            return null;
        }
        gemsPath = gemsPath.removeLastSegments(2);
        if (user) {
            gemsPath = gemsPath.append("lib/ruby/user-gems/1.8/gems");
            Path userGemsPathUbuntu = new Path("/var/lib/user-gems/1.8/gems");
            if (!env.getFile((IPath)gemsPath).exists() && env.getFile((IPath)userGemsPathUbuntu).exists()) {
                gemsPath = userGemsPathUbuntu;
            }
        } else {
            gemsPath = gemsPath.append("lib/ruby/gems/1.8/gems");
            Path gemsPathUbuntu = new Path("/var/lib/gems/1.8/gems");
            if (!env.getFile((IPath)gemsPath).exists() && env.getFile((IPath)gemsPathUbuntu).exists()) {
                gemsPath = gemsPathUbuntu;
            }
        }
        return gemsPath;
    }

    public boolean resolveRubyDebugGemExists() {
        IEnvironment environment = this.getInstall().getEnvironment();
        IExecutionEnvironment executionEnvironment = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        Bundle bundle = FastDebuggerPlugin.getDefault().getBundle();
        String output = ScriptLaunchUtil.runEmbeddedScriptReadContent((IExecutionEnvironment)executionEnvironment, (String)"scripts/check_debugger_gem.rb", (Bundle)bundle, (IFileHandle)this.getInstall().getInstallLocation(), (IProgressMonitor)new NullProgressMonitor());
        return output.startsWith("true");
    }

    protected void checkConfig(InterpreterConfig config, IEnvironment environment) throws CoreException {
        super.checkConfig(config, environment);
        Boolean check = (Boolean)config.getProperty(P_CHECK_RUBY_DEBUG);
        if (check != null && check.booleanValue()) {
            this.checkRubyDebug();
        }
    }

    private void checkRubyDebug() throws CoreException {
        if (!this.resolveRubyDebugGemExists()) {
            this.abort(NLS.bind((String)Messages.FastDebuggerRunner_rubyDebugGemDoesntSeemToBeInstalled, (Object[])new Object[]{this.getDebuggingEngine().getName(), this.getInstall().getInstallLocation().toOSString()}), null);
        }
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return ENGINE_ID;
    }

    protected String getLoggingEnabledPreferenceKey() {
        return "enable_logging";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected String getLogFilePathPreferenceKey() {
        return "log_file_path";
    }

    protected String getProcessType() {
        return "rubyInterpreter";
    }
}

