/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal.rspec;

import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestingEngine;
import org.eclipse.dltk.ruby.testing.internal.AbstractTestingEngineValidateVisitor;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.ruby.testing.internal.ResolverUtils;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingLaunchConfigurationDelegate;
import org.eclipse.dltk.ruby.testing.internal.rspec.RSpecTestRunnerUI;
import org.eclipse.dltk.ruby.testing.internal.rspec.RSpecUtils;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.osgi.util.NLS;

public class RspecTestingEngine
extends AbstractRubyTestingEngine {
    static final String RSPEC_RUNNER = "dltk-rspec-runner.rb";

    public IStatus validateSourceModule(ISourceModule module) {
        ModuleDeclaration declaration = ResolverUtils.parse(module);
        if (declaration == null) {
            return RspecTestingEngine.createStatus(2, Messages.validate_sourceErrors);
        }
        RSpecValidateVisitor visitor = new RSpecValidateVisitor();
        try {
            declaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            return RspecTestingEngine.createStatus(2, NLS.bind((String)Messages.validate_runtimeError, (Object)e.getMessage()));
        }
        return visitor.getStatus();
    }

    public String getMainScriptPath(ILaunchConfiguration configuration, IEnvironment scriptEnvironment) throws CoreException {
        return this.getRunnerFile(this.getBundle(), "/testing/", RSPEC_RUNNER).getPath();
    }

    public void configureLaunch(InterpreterConfig config, ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        String strPort = String.valueOf(this.allocatePort());
        launch.setAttribute("org.eclipse.dltk.testing.PORT", strPort);
        config.addEnvVar("RUBY_TESTING_PORT", strPort);
        String failureNames = configuration.getAttribute("org.eclipse.dltk.testing.FAILURENAMES", "");
        if (failureNames.length() != 0) {
            config.addScriptArg("-e");
            config.addScriptArg(failureNames);
        }
        if (!RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            String mainScript = AbstractScriptLaunchConfigurationDelegate.getMainScriptName((ILaunchConfiguration)configuration);
            IScriptProject scriptProject = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration);
            IPath scriptPath = scriptProject.getProject().getLocation().append(mainScript);
            config.addScriptArg(config.getEnvironment().getFile(scriptPath).toOSString());
        } else {
            String containerHandle = configuration.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
            Assert.isLegal((containerHandle.length() != 0 ? 1 : 0) != 0);
            IModelElement element = DLTKCore.create((String)containerHandle);
            Assert.isNotNull((Object)element);
            IResource resource = element.getUnderlyingResource();
            Assert.isNotNull((Object)resource);
            config.addScriptArg(resource.getLocation().toOSString());
        }
    }

    public ITestRunnerUI getTestRunnerUI(IScriptProject project, ILaunchConfiguration configuration) {
        return new RSpecTestRunnerUI(this, project);
    }

    static class RSpecValidateVisitor
    extends AbstractTestingEngineValidateVisitor {
        private static final String RSPEC = "spec";
        private int weight = 0;
        static final int REQUIRE_WEIGHT = 9;
        static final int TEST_WEIGHT = 3;
        private final Stack<ASTNode> contextCalls = new Stack();

        RSpecValidateVisitor() {
        }

        @Override
        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node instanceof CallExpression) {
                CallExpression call = (CallExpression)node;
                if (this.isRequire(call, RSPEC)) {
                    this.weight += 9;
                } else if (this.isMethodCall(call, RSpecUtils.CONTEXT_METHODS) || this.isMethodCall(call, RSpecUtils.SHARED_GROUP)) {
                    this.contextCalls.push(node);
                } else if (!this.contextCalls.isEmpty() && (this.isMethodCall(call, RSpecUtils.TEST_METHODS) || this.isMethodCall(call, RSpecUtils.TEST_SHARED))) {
                    this.weight += 3;
                }
            }
            return super.visitGeneral(node);
        }

        @Override
        public void endvisitGeneral(ASTNode node) throws Exception {
            if (!this.contextCalls.isEmpty() && this.contextCalls.peek() == node) {
                this.contextCalls.pop();
            }
            super.endvisitGeneral(node);
        }

        public IStatus getStatus() {
            if (this.weight >= 12) {
                return Status.OK_STATUS;
            }
            if (this.weight >= 3) {
                return RspecTestingEngine.createStatus(1, Messages.validate_probablyRSpec);
            }
            return RspecTestingEngine.createStatus(2, Messages.validate_notRSpec);
        }
    }
}

