/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.console.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ui.IScriptConsole;
import org.eclipse.dltk.console.ui.IScriptConsoleFactory;
import org.eclipse.dltk.console.ui.ScriptConsoleFactoryBase;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.console.TclConsoleUtil;
import org.eclipse.dltk.tcl.console.TclInterpreter;
import org.eclipse.dltk.tcl.internal.console.ui.TclConsole;
import org.eclipse.dltk.tcl.internal.debug.ui.TclDebugUIPlugin;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TclConsoleFactory
extends ScriptConsoleFactoryBase
implements IScriptConsoleFactory {
    protected IPreferenceStore getPreferenceStore() {
        return TclDebugUIPlugin.getDefault().getPreferenceStore();
    }

    protected ScriptConsolePrompt makeInvitation() {
        IPreferenceStore store = this.getPreferenceStore();
        return new ScriptConsolePrompt(store.getString("tclconsole.new_invitation"), store.getString("tclconsole.continue_invitation"));
    }

    protected TclConsole makeConsole(TclInterpreter interpreter, String id) {
        TclConsole console = new TclConsole(interpreter, id);
        console.setPrompt(this.makeInvitation());
        return console;
    }

    protected void showInterpreterPreferencePage(String natureId) {
        String preferencePageId = null;
        IDLTKUILanguageToolkit languageToolkit = null;
        languageToolkit = DLTKUILanguageManager.getLanguageToolkit((String)natureId);
        if (languageToolkit == null) {
            return;
        }
        preferencePageId = languageToolkit.getInterpreterPreferencePage();
        if (preferencePageId != null) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)preferencePageId, null, null);
            dialog.open();
        }
    }

    private void showQuestion() {
        boolean[] result = new boolean[1];
        DLTKDebugUIPlugin.getStandardDisplay().syncExec(() -> {
            String title = LaunchingMessages.NoDefaultInterpreterStatusHandler_title;
            String message = LaunchingMessages.NoDefaultInterpreterStatusHandler_message;
            blArray[0] = MessageDialog.openQuestion((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
            if (result[0]) {
                this.showInterpreterPreferencePage("org.eclipse.dltk.tcl.core.nature");
            }
        });
    }

    private TclConsole createConsoleInstance(IScriptInterpreter interpreter, String id) {
        ILaunch launch = null;
        if (interpreter == null) {
            block7: {
                try {
                    id = "default";
                    interpreter = new TclInterpreter();
                    if (ScriptRuntime.getDefaultInterpreterInstall((String)"org.eclipse.dltk.tcl.core.nature", (IEnvironment)LocalEnvironment.getInstance()) != null) break block7;
                    this.showQuestion();
                    if (ScriptRuntime.getDefaultInterpreterInstall((String)"org.eclipse.dltk.tcl.core.nature", (IEnvironment)LocalEnvironment.getInstance()) != null) break block7;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            launch = TclConsoleUtil.runDefaultTclInterpreter((TclInterpreter)((TclInterpreter)interpreter));
        }
        TclConsole console = this.makeConsole((TclInterpreter)interpreter, id);
        if (launch != null) {
            IProcess[] processes = launch.getProcesses();
            int i = 0;
            while (i < processes.length) {
                IStreamsProxy proxy = processes[i].getStreamsProxy();
                if (proxy != null) {
                    console.connect(proxy);
                }
                ++i;
            }
        }
        return console;
    }

    protected IScriptConsole createConsoleInstance() {
        return this.createConsoleInstance(null, null);
    }

    public IScriptConsole openConsole(IScriptInterpreter interpreter, String id, ILaunch launch) {
        TclConsole tclConsole = this.createConsoleInstance(interpreter, id);
        tclConsole.setLaunch(launch);
        this.registerAndOpenConsole((IScriptConsole)tclConsole);
        return tclConsole;
    }

    public void openConsole(IInterpreterInstall install, String consoleName) {
        ILaunch launch;
        TclInterpreter interpreter = new TclInterpreter();
        try {
            launch = TclConsoleUtil.runTclInterpreter((IInterpreterInstall)install, (TclInterpreter)interpreter);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error Launching Tcl Console", (String)e.toString(), (IStatus)new Status(4, "org.eclipse.dltk.tcl.debug.ui", e.getMessage(), (Throwable)e));
            return;
        }
        if (launch != null) {
            IProcess[] processes;
            IScriptConsole console = this.openConsole((IScriptInterpreter)interpreter, consoleName, launch);
            IProcess[] iProcessArray = processes = launch.getProcesses();
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                IStreamsProxy proxy = process.getStreamsProxy();
                if (proxy != null) {
                    console.connect(proxy);
                }
                ++n2;
            }
        }
    }
}

