/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.imp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.internal.imp.RegistryStruct;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RegistryUtil {
    private static final String PLATFORM = "platform:";
    private static final String EMPTY_STRING = "";
    private static final String COMMAND_ID = "commandId";
    private static final String CATEGORY_ID = "categoryId";
    private static final String COMPATIBILITY_VIEW = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
    private static final String VIEW_MENU = "ViewMenu";
    private static final String LAUNCHER = "launcher";
    private static final String EDITOR = "editor";
    private static final String VIEW = "View";
    private static final String CATEGORY_TAG = "categoryTag:";
    private static final String CATEGORY = "category";
    private static final String CLASS = "class";
    private static final String DESCRIPTION = "description";
    private static final String ICON = "icon";
    private static final String NAME = "name";
    private static final String ID = "id";
    public static final String HINT_VIEW = "view";
    public static final String HINT_EDITOR = "editor";
    public static final String HINT_COMPAT_VIEW = "compatibilityView";

    public static MApplicationElement[] getModelElements(Class<? extends MApplicationElement> t, String hint, MApplication application, IConfigurationElement ... elements) {
        Assert.isNotNull(t);
        Assert.isNotNull((Object)elements);
        Assert.isTrue((elements.length > 0 ? 1 : 0) != 0);
        if (t.equals(MCommand.class)) {
            return RegistryUtil.getCommands(elements, application);
        }
        if (t.equals(MCategory.class)) {
            return RegistryUtil.getCategories(elements);
        }
        if (t.equals(MPerspective.class)) {
            return RegistryUtil.getPerspectives(elements);
        }
        if (t.equals(MPart.class) && HINT_COMPAT_VIEW.equals(hint)) {
            return RegistryUtil.getViewsAsCompatibilityViews(elements);
        }
        if (t.equals(MPart.class)) {
            return RegistryUtil.getViews(elements);
        }
        if (t.equals(MHandler.class)) {
            return RegistryUtil.getHandlers(elements, application);
        }
        if (t.equals(MPartDescriptor.class) && "editor".equals(hint)) {
            return RegistryUtil.getEditorPartDescriptors(elements);
        }
        if (t.equals(MPartDescriptor.class) && HINT_VIEW.equals(hint)) {
            return RegistryUtil.getViewPartDescriptors(elements);
        }
        if (t.equals(MPartDescriptor.class) && HINT_COMPAT_VIEW.equals(hint)) {
            return RegistryUtil.getPartDescriptorsAsCompatibilyViews(elements);
        }
        return new MApplicationElement[0];
    }

    private static MCommand[] getCommands(IConfigurationElement[] elements, MApplication application) {
        ArrayList<MCommand> result = new ArrayList<MCommand>();
        MCommandsFactory commandsFactory = MCommandsFactory.INSTANCE;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MCommand command = commandsFactory.createCommand();
            command.setCommandName(element.getAttribute(NAME));
            command.setDescription(element.getAttribute(DESCRIPTION));
            command.setElementId(element.getAttribute(ID));
            String catId = element.getAttribute(CATEGORY_ID);
            if (catId != null && catId.trim().length() > 0) {
                List categories = application.getCategories();
                for (MCategory category : categories) {
                    if (!category.getElementId().equals(catId)) continue;
                    command.setCategory(category);
                    break;
                }
            }
            result.add(command);
            ++n2;
        }
        return result.toArray(new MCommand[0]);
    }

    private static MPerspective[] getPerspectives(IConfigurationElement[] elements) {
        ArrayList<MPerspective> result = new ArrayList<MPerspective>();
        MAdvancedFactory factory = MAdvancedFactory.INSTANCE;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MPerspective perspective = factory.createPerspective();
            perspective.setLabel(element.getAttribute(NAME));
            perspective.setIconURI(RegistryUtil.getIconURI(element, ICON));
            perspective.setElementId(element.getAttribute(ID));
            perspective.setToBeRendered(true);
            perspective.setVisible(true);
            result.add(perspective);
            ++n2;
        }
        return result.toArray(new MPerspective[0]);
    }

    private static MCategory[] getCategories(IConfigurationElement[] elements) {
        ArrayList<MCategory> result = new ArrayList<MCategory>();
        MCommandsFactory commandsFactory = MCommandsFactory.INSTANCE;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MCategory category = commandsFactory.createCategory();
            category.setDescription(element.getAttribute(DESCRIPTION));
            category.setElementId(element.getAttribute(ID));
            category.setName(element.getAttribute(NAME));
            result.add(category);
            ++n2;
        }
        return result.toArray(new MCategory[0]);
    }

    private static MPart[] getViews(IConfigurationElement[] elements) {
        ArrayList<MPart> result = new ArrayList<MPart>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MPart part = (MPart)EcoreUtil.create((EClass)BasicPackageImpl.Literals.PART);
            part.setElementId(element.getAttribute(ID));
            part.setLabel(element.getAttribute(NAME));
            part.setIconURI(RegistryUtil.getIconURI(element, ICON));
            part.setContributionURI(RegistryUtil.getContributionURI(element, CLASS));
            part.setToBeRendered(true);
            part.setVisible(true);
            part.setToolbar(RegistryUtil.createToolBar(part));
            part.getMenus().add(RegistryUtil.createViewMenu(part));
            part.setCloseable(true);
            part.getTags().add(VIEW);
            if (element.getAttribute(CATEGORY) != null) {
                part.getTags().add(CATEGORY_TAG + element.getAttribute(CATEGORY));
            }
            result.add(part);
            ++n2;
        }
        return result.toArray(new MPart[0]);
    }

    private static MToolBar createToolBar(MPart part) {
        MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
        toolBar.setElementId(part.getElementId());
        return toolBar;
    }

    private static MMenu createViewMenu(MPart part) {
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        menu.setElementId(part.getElementId());
        menu.getTags().add(VIEW_MENU);
        return menu;
    }

    private static MPart[] getViewsAsCompatibilityViews(IConfigurationElement[] elements) {
        MPart[] parts;
        ArrayList<MPart> result = new ArrayList<MPart>();
        MPart[] mPartArray = parts = RegistryUtil.getViews(elements);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            MPart part = mPartArray[n2];
            part.setContributionURI(COMPATIBILITY_VIEW);
            result.add(part);
            ++n2;
        }
        return result.toArray(new MPart[0]);
    }

    private static MPartDescriptor[] getPartDescriptorsAsCompatibilyViews(IConfigurationElement[] elements) {
        MPartDescriptor[] parts;
        ArrayList<MPartDescriptor> result = new ArrayList<MPartDescriptor>();
        MPartDescriptor[] mPartDescriptorArray = parts = RegistryUtil.getViewPartDescriptors(elements);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            MPartDescriptor part = mPartDescriptorArray[n2];
            part.setContributionURI(COMPATIBILITY_VIEW);
            result.add(part);
            ++n2;
        }
        return result.toArray(new MPartDescriptor[0]);
    }

    private static MPartDescriptor[] getEditorPartDescriptors(IConfigurationElement[] elements) {
        ArrayList<MPartDescriptor> result = new ArrayList<MPartDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MPartDescriptor part = (MPartDescriptor)EcoreUtil.create((EClass)BasicPackageImpl.Literals.PART_DESCRIPTOR);
            part.setElementId(element.getAttribute(ID));
            part.setLabel(element.getAttribute(NAME));
            part.setIconURI(RegistryUtil.getIconURI(element, ICON));
            if (element.getAttribute(CLASS) != null) {
                part.setContributionURI(RegistryUtil.getContributionURI(element, CLASS));
            } else {
                part.setContributionURI(RegistryUtil.getContributionURI(element, LAUNCHER));
            }
            part.setDirtyable(true);
            part.setAllowMultiple(true);
            MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
            toolBar.setElementId(part.getElementId());
            part.setToolbar(toolBar);
            MMenu menu = MMenuFactory.INSTANCE.createMenu();
            menu.setElementId(part.getElementId());
            menu.getTags().add(VIEW_MENU);
            part.getMenus().add(menu);
            part.setCloseable(true);
            result.add(part);
            ++n2;
        }
        return result.toArray(new MPartDescriptor[0]);
    }

    private static MPartDescriptor[] getViewPartDescriptors(IConfigurationElement[] elements) {
        ArrayList<MPartDescriptor> result = new ArrayList<MPartDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MPartDescriptor part = (MPartDescriptor)EcoreUtil.create((EClass)BasicPackageImpl.Literals.PART_DESCRIPTOR);
            part.setElementId(element.getAttribute(ID));
            part.setLabel(element.getAttribute(NAME));
            part.setIconURI(RegistryUtil.getIconURI(element, ICON));
            MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
            toolBar.setElementId(part.getElementId());
            part.setToolbar(toolBar);
            MMenu menu = MMenuFactory.INSTANCE.createMenu();
            menu.setElementId(part.getElementId());
            menu.getTags().add(VIEW_MENU);
            part.getMenus().add(menu);
            part.setCloseable(true);
            result.add(part);
            ++n2;
        }
        return result.toArray(new MPartDescriptor[0]);
    }

    private static MHandler[] getHandlers(IConfigurationElement[] elements, MApplication application) {
        ArrayList<MHandler> result = new ArrayList<MHandler>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MHandler hand = MCommandsFactory.INSTANCE.createHandler();
            hand.setElementId(element.getAttribute(ID));
            hand.setContributionURI(RegistryUtil.getContributionURI(element, CLASS));
            String cmdId = element.getAttribute(COMMAND_ID);
            if (cmdId != null && cmdId.trim().length() > 0) {
                List categories = application.getCommands();
                for (MCommand command : categories) {
                    if (!command.getElementId().equals(cmdId)) continue;
                    hand.setCommand(command);
                    break;
                }
            }
            result.add(hand);
            ++n2;
        }
        return result.toArray(new MHandler[0]);
    }

    private static String getIconURI(IConfigurationElement element, String attribute) {
        if (element.getAttribute(attribute) == null) {
            return EMPTY_STRING;
        }
        if (element.getAttribute(attribute).startsWith(PLATFORM)) {
            return element.getAttribute(attribute);
        }
        return "platform:/plugin/" + element.getContributor().getName() + "/" + element.getAttribute(attribute);
    }

    private static String getContributionURI(IConfigurationElement element, String attribute) {
        return "bundleclass://" + element.getContributor().getName() + "/" + element.getAttribute(attribute);
    }

    public static String[] getProvidingBundles(IExtensionRegistry registry, String extensionPoint, boolean isLive) {
        IExtension[] extensions;
        IExtensionLookup service = RegistryUtil.getService(IExtensionLookup.class, null);
        if (service == null) {
            return new String[]{"No " + IExtensionLookup.class.getName() + " service found."};
        }
        ArrayList<String> result = new ArrayList<String>();
        IExtension[] iExtensionArray = extensions = service.findExtensions(extensionPoint, isLive);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (!result.contains(element.getContributor().getName())) {
                    result.add(element.getContributor().getName());
                }
                ++n4;
            }
            ++n2;
        }
        Object[] resultArray = result.toArray(new String[0]);
        Arrays.sort(resultArray);
        return resultArray;
    }

    public static IConfigurationElement[] getExtensions(IExtensionRegistry registry, RegistryStruct struct, boolean isLive) {
        IExtension[] extensions;
        IExtensionLookup service = RegistryUtil.getService(IExtensionLookup.class, null);
        if (struct == null || service == null) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions = service.findExtensions(struct.getExtensionPoint(), isLive);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getContributor().getName().equals(struct.getBundle()) && element.getName().equals(struct.getExtensionPointName())) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    public static RegistryStruct getStruct(Class<? extends MApplicationElement> applicationElement, String hint) {
        if (applicationElement == MCommand.class) {
            return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.commands", "command", NAME);
        }
        if (applicationElement == MCategory.class) {
            return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.commands", CATEGORY, NAME);
        }
        if (applicationElement == MPerspective.class) {
            return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.perspectives", "perspective", NAME);
        }
        if (applicationElement == MPart.class) {
            return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.views", HINT_VIEW, NAME);
        }
        if (applicationElement == MHandler.class) {
            return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.handlers", "handler", COMMAND_ID);
        }
        if (applicationElement == MPart.class) {
            return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.views", HINT_VIEW, NAME);
        }
        if (applicationElement == MPartDescriptor.class) {
            if (hint == "editor") {
                return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.editors", "editor", NAME);
            }
            if (hint == HINT_VIEW || hint == HINT_COMPAT_VIEW) {
                return new RegistryStruct(EMPTY_STRING, "org.eclipse.ui.views", HINT_VIEW, NAME);
            }
        }
        return null;
    }

    private static <T> T getService(Class<T> clazz, String filter) {
        try {
            BundleContext context = FrameworkUtil.getBundle(RegistryUtil.class).getBundleContext();
            Collection references = context.getServiceReferences(clazz, filter);
            Iterator iterator = references.iterator();
            if (iterator.hasNext()) {
                ServiceReference reference = (ServiceReference)iterator.next();
                return (T)context.getService(reference);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return null;
    }
}

