/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.eclipse.resources.mgt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;

public class CopyFilesTask
implements ITaskProduction {
    private static final String CONTRACT_PLUGIN_ID_TAG = "plugin_id";
    private static final String DESTINATION_PATH = "destination_path";
    private static final String SOURCE_PATH = "source_path";

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        IFolder source = this.getSourceFolder(productionContext);
        IFolder destination = this.getDestinationFolder(productionContext);
        try {
            this.copy(source, destination);
        }
        catch (CoreException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    private void copy(IFolder source, IFolder destination) throws CoreException {
        IResource[] iResourceArray = source.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1) {
                this.copy((IFile)resource, destination);
            }
            ++n2;
        }
    }

    private void copy(IFile file, IFolder destination) throws CoreException {
        IFile destinationFile = destination.getFile(file.getName());
        if (destinationFile.exists()) {
            destinationFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        file.copy(destinationFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        IFolder folder = this.getDestinationFolder(productionContext);
        try {
            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        IFolder source = this.getSourceFolder(productionContext);
        IFolder destination = this.getDestinationFolder(productionContext);
        try {
            source.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            destination.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    private String getPluginId(ITaskProductionContext context) throws InvocationException {
        return (String)context.getInputValue((Object)CONTRACT_PLUGIN_ID_TAG, String.class);
    }

    private String getDestinationPath(ITaskProductionContext context) throws InvocationException {
        return (String)context.getInputValue((Object)DESTINATION_PATH, String.class);
    }

    private String getSourcePath(ITaskProductionContext context) throws InvocationException {
        return (String)context.getInputValue((Object)SOURCE_PATH, String.class);
    }

    private IFolder getDestinationFolder(ITaskProductionContext context) throws InvocationException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getPluginId(context));
        return project.getFolder((IPath)new Path(this.getDestinationPath(context)));
    }

    private IFolder getSourceFolder(ITaskProductionContext context) throws InvocationException {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.getSourcePath(context)));
    }
}

