/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.task.ant.ui.contributions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.platform.uri.TargetPlatformURIConverter;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.portfolio.task.ant.Activator;
import org.eclipse.egf.portfolio.task.ant.ui.Messages;
import org.eclipse.egf.portfolio.task.ant.ui.contributions.PlatformEditorInput;
import org.eclipse.egf.task.ui.contributions.TaskImplementationOpenAction;
import org.eclipse.egf.task.ui.contributions.TaskMenuContributor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenAntTaskImplementationMenuContributor
extends TaskMenuContributor {
    public static final String OPEN_IMPLEMENTATION_ACTION_ID = "open-task-ant-implementation";

    protected TaskImplementationOpenAction createAction(Task task) {
        OpenAction openAction = new OpenAction(task);
        openAction.setText(Messages.TaskImplementationMenuContributor_openAction_label);
        return openAction;
    }

    protected String getExpectedKind() {
        return Activator.KIND_ANT;
    }

    protected static class OpenAction
    extends TaskImplementationOpenAction {
        public OpenAction(Task task) {
            super(task, OpenAntTaskImplementationMenuContributor.OPEN_IMPLEMENTATION_ACTION_ID);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean doRun() throws Exception {
            IWorkbench workbench = PlatformUI.getWorkbench();
            String antFile = this.getImplementation();
            URI uri = URI.createURI((String)antFile);
            TargetPlatformURIConverter converter = new TargetPlatformURIConverter();
            if ((uri = converter.normalize(uri)).isPlatformResource()) {
                Path path = new Path(uri.toPlatformString(true));
                IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (findMember == null || !(findMember instanceof IFile)) return false;
                IEditorDescriptor editorDesc = IDE.getEditorDescriptor((IFile)((IFile)findMember), (boolean)true);
                IDE.openEditor((IWorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)findMember), (String)editorDesc.getId());
                return true;
            } else {
                IDE.openEditor((IWorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new PlatformEditorInput(antFile), (String)"org.eclipse.ui.DefaultTextEditor", (boolean)false);
            }
            return true;
        }
    }
}

