/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.NewWizard;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWizardPage
extends WizardPage {
    private final String resourceType;
    private final String title;
    private TreeViewer parentViewer;
    private boolean parentRevealed;
    private Object parent;
    private Text nameText;
    private boolean nameModified;
    private String name;

    public NewWizardPage(String resourceType, String title, IStructuredSelection selection) {
        super("NewPage");
        this.resourceType = resourceType;
        this.title = title;
        this.parent = selection.getFirstElement();
    }

    public NewWizard getWizard() {
        return (NewWizard)super.getWizard();
    }

    public final Object getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public void createControl(Composite parentControl) {
        this.setTitle(this.title);
        this.setImageDescriptor(OM.getImageDescriptor("icons/wiz/new_" + this.resourceType + ".gif"));
        this.setMessage("Enter the name of the " + this.title.toLowerCase() + ".");
        Composite container = new Composite(parentControl, 0);
        GridLayout containerGridLayout = new GridLayout();
        containerGridLayout.numColumns = 2;
        container.setLayout((Layout)containerGridLayout);
        this.setControl((Control)container);
        Label parentLabel = new Label(container, 0);
        parentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        parentLabel.setText("Select the parent folder:");
        this.parentViewer = CDOCheckoutContentProvider.createTreeViewer(container);
        this.parentViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.parentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NewWizardPage.this.parentRevealed) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    NewWizardPage.this.parent = selection.getFirstElement();
                }
                NewWizardPage.this.validate();
            }
        });
        Label nameLabel = new Label(container, 0);
        nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        nameLabel.setText("Name:");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWizardPage.this.nameModified = true;
                NewWizardPage.this.validate();
            }
        });
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    NewWizardPage.this.getShell().setText(NewWizardPage.this.title);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NewWizardPage.this.revealParent();
                NewWizardPage.this.validate();
                NewWizardPage.this.nameText.setFocus();
                NewWizardPage.this.nameText.selectAll();
            }
        });
    }

    private void revealParent() {
        if (this.parent != null) {
            ArrayList<Object> segments = new ArrayList<Object>();
            this.fillSegments(segments, this.parent);
            int i = 0;
            while (i < segments.size() - 1) {
                Object segment = segments.get(i);
                this.parentViewer.setExpandedState(segment, true);
                ++i;
            }
            this.parentRevealed = true;
            this.parentViewer.setSelection((ISelection)new StructuredSelection(this.parent), true);
        }
    }

    private void fillSegments(List<Object> segments, Object node) {
        if (node instanceof CDOCheckout) {
            segments.add(node);
            return;
        }
        if (node instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)node;
            Adapter adapter = EcoreUtil.getAdapter((List)folder.eAdapters(), CDOCheckout.class);
            if (adapter != null) {
                this.fillSegments(segments, adapter);
            } else {
                CDOResourceFolder parent = folder.getFolder();
                if (parent == null) {
                    parent = EcoreUtil.getAdapter((List)folder.cdoView().getRootResource().eAdapters(), CDOCheckout.class);
                }
                this.fillSegments(segments, parent);
            }
        }
        segments.add(node);
    }

    private void validate() {
        try {
            String name = this.nameText.getText();
            if (!this.nameModified) {
                name = this.getUniqueName();
                this.nameText.setText(name);
            } else {
                name.length();
                if (!this.isUnique(name)) {
                    throw new Exception("Name is not unique within the parent folder.");
                }
                this.name = name;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
            this.setPageComplete(false);
        }
    }

    private EList<EObject> getChildrenOfParent() {
        if (this.parent instanceof CDOCheckout) {
            CDOCheckout checkout = (CDOCheckout)this.parent;
            return checkout.getRootObject().eContents();
        }
        if (this.parent instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)this.parent;
            return folder.eContents();
        }
        return ECollections.emptyEList();
    }

    private String getUniqueName() {
        HashSet<String> names = new HashSet<String>();
        for (EObject eObject : this.getChildrenOfParent()) {
            CDOResourceNode node;
            String name;
            if (!(eObject instanceof CDOResourceNode) || !(name = (node = (CDOResourceNode)eObject).getName()).startsWith(this.resourceType)) continue;
            names.add(name);
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String name = String.valueOf(this.resourceType) + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new IllegalStateException("Too many children");
    }

    private boolean isUnique(String name) {
        for (EObject eObject : this.getChildrenOfParent()) {
            CDOResourceNode node;
            if (!(eObject instanceof CDOResourceNode) || !ObjectUtil.equals((Object)(node = (CDOResourceNode)eObject).getName(), (Object)name)) continue;
            return false;
        }
        return true;
    }
}

