/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.embedded;

import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.embedded.ServerSession;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerBranchLoader
implements InternalCDOBranchManager.BranchLoader3 {
    private final InternalCDOBranchManager.BranchLoader3 delegate;
    private final ISessionManager sessionManager;

    public ServerBranchLoader(InternalCDOBranchManager.BranchLoader3 delegate) {
        this.delegate = delegate;
        this.sessionManager = ((IRepository)delegate).getSessionManager();
    }

    public InternalCDOBranchManager.BranchLoader3 getDelegate() {
        return this.delegate;
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                Pair pair = this.delegate.createBranch(branchID, branchInfo);
                return pair;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.createBranch(branchID, branchInfo);
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = this.delegate.loadBranch(branchID);
                return branchInfo;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray = this.delegate.loadSubBranches(branchID);
                return subBranchInfoArray;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                int n = this.delegate.loadBranches(startID, endID, branchHandler);
                return n;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadBranches(startID, endID, branchHandler);
    }

    public void renameBranch(int branchID, String oldName, String newName) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                this.delegate.renameBranch(branchID, oldName, newName);
            }
            finally {
                StoreThreadLocal.release();
            }
        } else {
            this.delegate.renameBranch(branchID, oldName, newName);
        }
    }

    @Deprecated
    public void deleteBranch(int branchID) {
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
    }

    private InternalSession getServerSession() {
        InternalSession serverSession = ServerSession.get();
        if (serverSession == null) {
            serverSession = (InternalSession)this.sessionManager.getSessions()[0];
        }
        return serverSession;
    }
}

